/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.guice.PropertiesModule;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.initialization.InitializationTest;
import org.apache.hive.druid.org.apache.druid.server.StatusResource;
import org.junit.Assert;
import org.junit.Test;

public class StatusResourceTest {
    @Test
    public void testLoadedModules() {
        ImmutableList modules = ImmutableList.of((Object)new InitializationTest.TestDruidModule());
        List statusResourceModuleList = new StatusResource.Status((Collection)modules).getModules();
        Assert.assertEquals((String)"Status should have all modules loaded!", (long)modules.size(), (long)statusResourceModuleList.size());
        for (DruidModule module : modules) {
            String moduleName = module.getClass().getName();
            boolean contains = Boolean.FALSE;
            for (StatusResource.ModuleVersion version : statusResourceModuleList) {
                if (!version.getName().equals(moduleName)) continue;
                contains = Boolean.TRUE;
            }
            Assert.assertTrue((String)("Status resource should contain module " + moduleName), (boolean)contains);
        }
    }

    @Test
    public void testPropertiesWithRestrictedConfigs() {
        Injector injector = Guice.createInjector(Collections.singletonList(new PropertiesModule(Collections.singletonList("status.resource.test.runtime.properties"))));
        Map returnedProperties = ((StatusResource)injector.getInstance(StatusResource.class)).getProperties();
        HashSet hiddenProperties = new HashSet();
        Splitter.on((String)",").split((CharSequence)returnedProperties.get("druid.server.hiddenProperties")).forEach(hiddenProperties::add);
        hiddenProperties.forEach(property -> Assert.assertNull(returnedProperties.get(property)));
    }
}

