/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderLocalCacheManager;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentManagerThreadSafetyTest {
    private static final int NUM_THREAD = 4;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TestSegmentPuller segmentPuller;
    private ObjectMapper objectMapper;
    private IndexIO indexIO;
    private File segmentCacheDir;
    private File segmentDeepStorageDir;
    private SegmentLoaderLocalCacheManager segmentLoader;
    private SegmentManager segmentManager;
    private ExecutorService exec;

    @Before
    public void setup() throws IOException {
        this.segmentPuller = new TestSegmentPuller();
        this.objectMapper = new DefaultObjectMapper().registerModule((Module)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local"), new NamedType(TestSegmentizerFactory.class, "test")})).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)this.segmentPuller));
        this.indexIO = new IndexIO(this.objectMapper, () -> 0);
        this.segmentCacheDir = this.temporaryFolder.newFolder();
        this.segmentDeepStorageDir = this.temporaryFolder.newFolder();
        this.segmentLoader = new SegmentLoaderLocalCacheManager(this.indexIO, new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(SegmentManagerThreadSafetyTest.this.segmentCacheDir, null, null));
            }
        }, this.objectMapper);
        this.segmentManager = new SegmentManager((SegmentLoader)this.segmentLoader);
        this.exec = Execs.multiThreaded((int)4, (String)"SegmentManagerThreadSafetyTest-%d");
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
    }

    @After
    public void teardown() throws IOException {
        this.exec.shutdownNow();
        FileUtils.deleteDirectory((File)this.segmentCacheDir);
    }

    @Test(timeout=6000L)
    public void testLoadSameSegment() throws IOException, ExecutionException, InterruptedException {
        DataSegment segment = this.createSegment("2019-01-01/2019-01-02");
        List futures = IntStream.range(0, 16).mapToObj(i -> this.exec.submit(() -> this.segmentManager.loadSegment(segment, false))).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)1L, (long)this.segmentPuller.numFileLoaded.size());
        Assert.assertEquals((long)1L, (long)((Integer)this.segmentPuller.numFileLoaded.values().iterator().next()).intValue());
        Assert.assertEquals((long)0L, (long)this.segmentLoader.getSegmentLocks().size());
    }

    @Test(timeout=6000L)
    public void testLoadMultipleSegments() throws IOException, ExecutionException, InterruptedException {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>(88);
        for (int i2 = 0; i2 < 11; ++i2) {
            for (int j = 0; j < 8; ++j) {
                segments.add(this.createSegment(StringUtils.format((String)"2019-%02d-01/2019-%02d-01", (Object[])new Object[]{i2 + 1, i2 + 2})));
            }
        }
        List futures = IntStream.range(0, 16).mapToObj(i -> this.exec.submit(() -> {
            for (DataSegment segment : segments) {
                try {
                    this.segmentManager.loadSegment(segment, false);
                }
                catch (SegmentLoadingException e) {
                    throw new RuntimeException(e);
                }
            }
        })).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)11L, (long)this.segmentPuller.numFileLoaded.size());
        Assert.assertEquals((long)1L, (long)((Integer)this.segmentPuller.numFileLoaded.values().iterator().next()).intValue());
        Assert.assertEquals((long)0L, (long)this.segmentLoader.getSegmentLocks().size());
    }

    private DataSegment createSegment(String interval) throws IOException {
        DataSegment tmpSegment = new DataSegment("dataSource", Intervals.of((String)interval), "version", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
        String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)tmpSegment, (boolean)false);
        File segmentDir = new File(this.segmentDeepStorageDir, storageDir);
        org.apache.commons.io.FileUtils.forceMkdir((File)segmentDir);
        File factoryJson = new File(segmentDir, "factory.json");
        this.objectMapper.writeValue(factoryJson, (Object)new TestSegmentizerFactory());
        return tmpSegment.withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)segmentDir.getAbsolutePath()));
    }

    private static class TestSegmentizerFactory
    implements SegmentizerFactory {
        private TestSegmentizerFactory() {
        }

        public Segment factorize(final DataSegment segment, File parentDir, boolean lazy) {
            return new Segment(){

                public SegmentId getId() {
                    return segment.getId();
                }

                public Interval getDataInterval() {
                    return segment.getInterval();
                }

                @Nullable
                public QueryableIndex asQueryableIndex() {
                    throw new UnsupportedOperationException();
                }

                public StorageAdapter asStorageAdapter() {
                    throw new UnsupportedOperationException();
                }

                public <T> T as(Class<T> clazz) {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            };
        }
    }

    private static class TestSegmentPuller
    extends LocalDataSegmentPuller {
        private final Map<File, Integer> numFileLoaded = new HashMap<File, Integer>();

        private TestSegmentPuller() {
        }

        public FileUtils.FileCopyResult getSegmentFiles(File sourceFile, File dir) {
            this.numFileLoaded.compute(sourceFile, (f, numLoaded) -> numLoaded == null ? 1 : numLoaded + 1);
            try {
                org.apache.commons.io.FileUtils.copyDirectory((File)sourceFile, (File)dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new FileUtils.FileCopyResult(new File[0]){

                public long size() {
                    return 100L;
                }
            };
        }
    }
}

