/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.segment.AbstractSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.server.SegmentManager;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentManagerTest {
    private static final SegmentLoader SEGMENT_LOADER = new SegmentLoader(){

        public boolean isSegmentLoaded(DataSegment segment) {
            return false;
        }

        public Segment getSegment(DataSegment segment, boolean lazy) {
            return new SegmentForTesting(MapUtils.getString((Map)segment.getLoadSpec(), (String)"version"), (Interval)segment.getLoadSpec().get("interval"));
        }

        public File getSegmentFiles(DataSegment segment) {
            throw new UnsupportedOperationException();
        }

        public void cleanup(DataSegment segment) {
        }
    };
    private static final List<DataSegment> SEGMENTS = ImmutableList.of((Object)new DataSegment("small_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 10L), (Object)new DataSegment("small_source", Intervals.of((String)"1000/2000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 10L), (Object)new DataSegment("large_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L), (Object)new DataSegment("large_source", Intervals.of((String)"1000/2000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L), (Object)new DataSegment("large_source", Intervals.of((String)"1000/2000"), "1", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"1000/2000"), (Object)"version", (Object)1), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 100L));
    private ExecutorService executor;
    private SegmentManager segmentManager;

    @Before
    public void setup() {
        this.segmentManager = new SegmentManager(SEGMENT_LOADER);
        this.executor = Executors.newFixedThreadPool(SEGMENTS.size());
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testLoadSegment() throws ExecutionException, InterruptedException, SegmentLoadingException {
        List futures = SEGMENTS.stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false))).collect(Collectors.toList());
        for (Future eachFuture : futures) {
            Assert.assertTrue((boolean)((Boolean)eachFuture.get()));
        }
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException {
        for (DataSegment eachSegment : SEGMENTS) {
            Assert.assertTrue((boolean)this.segmentManager.loadSegment(eachSegment, false));
        }
        List futures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future eachFuture : futures) {
            eachFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    @Test
    public void testLoadDropSegment() throws SegmentLoadingException, ExecutionException, InterruptedException {
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false));
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(2), false));
        List loadFutures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)).stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false))).collect(Collectors.toList());
        List dropFutures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future eachFuture : loadFutures) {
            Assert.assertTrue((boolean)((Boolean)eachFuture.get()));
        }
        for (Future eachFuture : dropFutures) {
            eachFuture.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(3), (Object)SEGMENTS.get(4)));
    }

    @Test
    public void testLoadDuplicatedSegmentsSequentially() throws SegmentLoadingException {
        for (DataSegment segment : SEGMENTS) {
            Assert.assertTrue((boolean)this.segmentManager.loadSegment(segment, false));
        }
        Assert.assertFalse((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false));
        this.assertResult(SEGMENTS);
    }

    @Test
    public void testLoadDuplicatedSegmentsInParallel() throws ExecutionException, InterruptedException, SegmentLoadingException {
        List futures = ImmutableList.of((Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0), (Object)SEGMENTS.get(0)).stream().map(segment -> this.executor.submit(() -> this.segmentManager.loadSegment(segment, false))).collect(Collectors.toList());
        int numSucceededFutures = 0;
        int numFailedFutures = 0;
        for (Future future : futures) {
            numSucceededFutures += (Boolean)future.get() != false ? 1 : 0;
            numFailedFutures += (Boolean)future.get() != false ? 0 : 1;
        }
        Assert.assertEquals((long)1L, (long)numSucceededFutures);
        Assert.assertEquals((long)2L, (long)numFailedFutures);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsSequentially() throws SegmentLoadingException {
        Assert.assertTrue((boolean)this.segmentManager.loadSegment(SEGMENTS.get(0), false));
        this.segmentManager.dropSegment(SEGMENTS.get(2));
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testNonExistingSegmentsInParallel() throws SegmentLoadingException, ExecutionException, InterruptedException {
        this.segmentManager.loadSegment(SEGMENTS.get(0), false);
        List futures = ImmutableList.of((Object)SEGMENTS.get(1), (Object)SEGMENTS.get(2)).stream().map(segment -> this.executor.submit(() -> {
            this.segmentManager.dropSegment(segment);
            return null;
        })).collect(Collectors.toList());
        for (Future future : futures) {
            future.get();
        }
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
    }

    @Test
    public void testRemoveEmptyTimeline() throws SegmentLoadingException {
        this.segmentManager.loadSegment(SEGMENTS.get(0), false);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)SEGMENTS.get(0)));
        Assert.assertEquals((long)1L, (long)this.segmentManager.getDataSources().size());
        this.segmentManager.dropSegment(SEGMENTS.get(0));
        Assert.assertEquals((long)0L, (long)this.segmentManager.getDataSources().size());
    }

    @Test
    public void testGetNonExistingTimeline() {
        Assert.assertNull((Object)this.segmentManager.getTimeline("nonExisting"));
    }

    @Test
    public void testLoadAndDropNonRootGenerationSegment() throws SegmentLoadingException {
        DataSegment segment = new DataSegment("small_source", Intervals.of((String)"0/1000"), "0", (Map)ImmutableMap.of((Object)"interval", (Object)Intervals.of((String)"0/1000"), (Object)"version", (Object)0), new ArrayList(), new ArrayList(), (ShardSpec)new NumberedOverwriteShardSpec(32778, 10, 20, 1, 1), Integer.valueOf(0), 10L);
        this.segmentManager.loadSegment(segment, false);
        this.assertResult((List<DataSegment>)ImmutableList.of((Object)segment));
        this.segmentManager.dropSegment(segment);
        this.assertResult((List<DataSegment>)ImmutableList.of());
    }

    private void assertResult(List<DataSegment> expectedExistingSegments) throws SegmentLoadingException {
        Map<String, Long> expectedDataSourceSizes = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, DataSegment::getSize, Long::sum));
        Map<String, Long> expectedDataSourceCounts = expectedExistingSegments.stream().collect(Collectors.toMap(DataSegment::getDataSource, segment -> 1L, Long::sum));
        HashMap<String, VersionedIntervalTimeline> expectedDataSources = new HashMap<String, VersionedIntervalTimeline>();
        for (DataSegment segment2 : expectedExistingSegments) {
            VersionedIntervalTimeline expectedTimeline = expectedDataSources.computeIfAbsent(segment2.getDataSource(), k -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
            expectedTimeline.add(segment2.getInterval(), (Object)segment2.getVersion(), segment2.getShardSpec().createChunk((Object)ReferenceCountingSegment.wrapSegment((Segment)SEGMENT_LOADER.getSegment(segment2, false), (ShardSpec)segment2.getShardSpec())));
        }
        Assert.assertEquals(expectedDataSourceCounts, (Object)this.segmentManager.getDataSourceCounts());
        Assert.assertEquals(expectedDataSourceSizes, (Object)this.segmentManager.getDataSourceSizes());
        Map dataSources = this.segmentManager.getDataSources();
        Assert.assertEquals((long)expectedDataSources.size(), (long)dataSources.size());
        dataSources.forEach((sourceName, dataSourceState) -> {
            Assert.assertEquals((long)((Long)expectedDataSourceCounts.get(sourceName)), (long)dataSourceState.getNumSegments());
            Assert.assertEquals((long)((Long)expectedDataSourceSizes.get(sourceName)), (long)dataSourceState.getTotalSegmentSize());
            Assert.assertEquals((Object)((VersionedIntervalTimeline)expectedDataSources.get(sourceName)).getAllTimelineEntries(), (Object)dataSourceState.getTimeline().getAllTimelineEntries());
        });
    }

    private static class SegmentForTesting
    extends AbstractSegment {
        private final String version;
        private final Interval interval;

        SegmentForTesting(String version, Interval interval) {
            this.version = version;
            this.interval = interval;
        }

        public String getVersion() {
            return this.version;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentId getId() {
            return SegmentId.dummy((String)this.version);
        }

        public Interval getDataInterval() {
            return this.interval;
        }

        public QueryableIndex asQueryableIndex() {
            throw new UnsupportedOperationException();
        }

        public StorageAdapter asStorageAdapter() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

