/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.query.DataSource;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.TableDataSource;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.server.QueryStats;
import org.apache.hive.druid.org.apache.druid.server.RequestLogLine;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestLogLineTest {
    private Query query;

    @Before
    public void setUp() throws Exception {
        this.query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void nullTimestamp() throws JsonProcessingException {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, null, (String)"", (QueryStats)new QueryStats((Map)ImmutableMap.of()));
    }

    @Test(expected=NullPointerException.class)
    public void nullQueryStats() throws JsonProcessingException {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, (DateTime)DateTimes.nowUtc(), (String)"", null);
    }

    @Test
    public void nullRemoteAddressAndNullSqlQueryContext() throws JsonProcessingException {
        RequestLogLine requestLogLine = RequestLogLine.forNative((Query)this.query, (DateTime)DateTimes.nowUtc(), null, (QueryStats)new QueryStats((Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"", (Object)requestLogLine.getRemoteAddr());
        requestLogLine.getNativeQueryLine(new ObjectMapper());
        requestLogLine = RequestLogLine.forSql((String)"", null, (DateTime)DateTimes.nowUtc(), null, (QueryStats)new QueryStats((Map)ImmutableMap.of()));
        Assert.assertEquals((Object)"", (Object)requestLogLine.getRemoteAddr());
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)requestLogLine.getSqlQueryContext());
        requestLogLine.getSqlQueryLine(new ObjectMapper());
    }
}

