/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.org.apache.druid.server.QueryLifecycleFactory;
import org.apache.hive.druid.org.apache.druid.server.QueryManager;
import org.apache.hive.druid.org.apache.druid.server.QueryResource;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.TestRequestLogger;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.server.security.Access;
import org.apache.hive.druid.org.apache.druid.server.security.Action;
import org.apache.hive.druid.org.apache.druid.server.security.AuthConfig;
import org.apache.hive.druid.org.apache.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.org.apache.druid.server.security.Authorizer;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.org.apache.druid.server.security.ForbiddenException;
import org.apache.hive.druid.org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryResourceTest {
    private static final QueryToolChestWarehouse WAREHOUSE = new MapQueryToolChestWarehouse((Map)ImmutableMap.of());
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final AuthenticationResult AUTHENTICATION_RESULT = new AuthenticationResult("druid", "druid", null, null);
    private final HttpServletRequest testServletRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
    public static final QuerySegmentWalker TEST_SEGMENT_WALKER = new QuerySegmentWalker(){

        public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
            return new QueryRunner<T>(){

                public Sequence<T> run(QueryPlus<T> query, ResponseContext responseContext) {
                    return Sequences.empty();
                }
            };
        }

        public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
            return this.getQueryRunnerForIntervals(null, null);
        }
    };
    private static final ServiceEmitter NOOP_SERVICE_EMITTER = new NoopServiceEmitter();
    private QueryResource queryResource;
    private QueryManager queryManager;
    private TestRequestLogger testRequestLogger;
    private static final String SIMPLE_TIMESERIES_QUERY = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ]\n}";

    @BeforeClass
    public static void staticSetup() {
        EmittingLogger.registerEmitter((ServiceEmitter)NOOP_SERVICE_EMITTER);
    }

    @Before
    public void setup() {
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        this.queryManager = new QueryManager();
        this.testRequestLogger = new TestRequestLogger();
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER), JSON_MAPPER, JSON_MAPPER, this.queryManager, new AuthConfig(), null, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory());
    }

    @Test
    public void testGoodQuery() throws IOException {
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes("UTF-8")), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithNullAcceptHeader() throws IOException {
        Object acceptHeader = null;
        String contentTypeHeader = "application/json";
        EasyMock.reset((Object[])new Object[]{this.testServletRequest});
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn(acceptHeader).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes("UTF-8")), null, this.testServletRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithEmptyAcceptHeader() throws IOException {
        String acceptHeader = "";
        String contentTypeHeader = "application/json";
        EasyMock.reset((Object[])new Object[]{this.testServletRequest});
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes("UTF-8")), null, this.testServletRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithSmileAcceptHeader() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        HttpServletRequest smileRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)smileRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        smileRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)smileRequest.getHeader("Accept")).andReturn((Object)"application/x-jackson-smile").anyTimes();
        EasyMock.expect((Object)smileRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{smileRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes("UTF-8")), null, smileRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
        EasyMock.verify((Object[])new Object[]{smileRequest});
    }

    @Test
    public void testBadQuery() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream("Meka Leka Hi Meka Hiney Ho".getBytes("UTF-8")), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testSecuredQuery() throws Exception {
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().times(1);
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (resource.getName().equals("allow")) {
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper), JSON_MAPPER, JSON_MAPPER, this.queryManager, new AuthConfig(), authMapper, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory());
        try {
            this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes("UTF-8")), null, this.testServletRequest);
            Assert.fail((String)"doPost did not throw ForbiddenException for an unauthorized query");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\"}".getBytes("UTF-8")), null, this.testServletRequest);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((StreamingOutput)response.getEntity()).write((OutputStream)baos);
        List responses = (List)JSON_MAPPER.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertEquals((Object)true, this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("success"));
        Assert.assertEquals((Object)"druid", this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("identity"));
    }

    @Test(timeout=60000L)
    public void testSecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        final CountDownLatch waitFinishLatch = new CountDownLatch(2);
        final CountDownLatch startAwaitLatch = new CountDownLatch(1);
        final CountDownLatch cancelledCountDownLatch = new CountDownLatch(1);
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                startAwaitLatch.countDown();
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                cancelledCountDownLatch.countDown();
                                throw new RuntimeException(e);
                            }
                            return new Access(true);
                        }
                        return new Access(true);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper), JSON_MAPPER, JSON_MAPPER, this.queryManager, new AuthConfig(), authMapper, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory());
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response response = QueryResourceTest.this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes("UTF-8")), null, QueryResourceTest.this.testServletRequest);
                    Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                waitFinishLatch.countDown();
            }
        });
        this.queryManager.registerQuery(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Response response = QueryResourceTest.this.queryResource.cancelQuery("id_1", QueryResourceTest.this.testServletRequest);
                Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
                waitForCancellationLatch.countDown();
                waitFinishLatch.countDown();
            }
        });
        waitFinishLatch.await();
        cancelledCountDownLatch.await();
    }

    @Test(timeout=60000L)
    public void testDenySecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        final CountDownLatch waitFinishLatch = new CountDownLatch(2);
        final CountDownLatch startAwaitLatch = new CountDownLatch(1);
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper), JSON_MAPPER, JSON_MAPPER, this.queryManager, new AuthConfig(), authMapper, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory());
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    startAwaitLatch.countDown();
                    Response response = QueryResourceTest.this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes("UTF-8")), null, QueryResourceTest.this.testServletRequest);
                    Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                waitFinishLatch.countDown();
            }
        });
        this.queryManager.registerQuery(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    QueryResourceTest.this.queryResource.cancelQuery("id_1", QueryResourceTest.this.testServletRequest);
                }
                catch (ForbiddenException e) {
                    waitForCancellationLatch.countDown();
                    waitFinishLatch.countDown();
                }
            }
        });
        waitFinishLatch.await();
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.testServletRequest});
    }
}

