/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.junit.Assert;
import org.junit.Test;

public class DruidNodeTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();

    public DruidNodeTest() {
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(Integer.class, (Object)Integer.MAX_VALUE).addValue(String.class, (Object)"DUMMY"));
    }

    @Test
    public void testDefaultsAndSanity() {
        String service = "test/service";
        DruidNode node = new DruidNode("test/service", null, false, null, null, true, false);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)HostAndPort.fromString((String)DruidNode.getDefaultHost()).toString(), (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "2001:db8:85a3::8a2e:370:7334", false, Integer.valueOf(-1), null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"[2001:db8:85a3::8a2e:370:7334]", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "abc:123", false, null, null, true, false);
        Assert.assertEquals((Object)"abc", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"abc:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "2001:db8:85a3::8a2e:370:7334", false, null, null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertTrue((8080 <= node.getPlaintextPort() ? 1 : 0) != 0);
        node = new DruidNode("test/service", "[2001:db8:85a3::8a2e:370:7334]", false, null, null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertTrue((8080 <= node.getPlaintextPort() ? 1 : 0) != 0);
        node = new DruidNode("test/service", "abc", false, null, null, true, false);
        Assert.assertEquals((Object)"abc", (Object)node.getHost());
        Assert.assertTrue((8080 <= node.getPlaintextPort() ? 1 : 0) != 0);
        node = new DruidNode("test/service", "abc", false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)"abc", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"abc:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "abc:123", false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)"abc", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"abc:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "[2001:db8:85a3::8a2e:370:7334]:123", false, null, null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"[2001:db8:85a3::8a2e:370:7334]:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "2001:db8:85a3::8a2e:370:7334", false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"[2001:db8:85a3::8a2e:370:7334]:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", "[2001:db8:85a3::8a2e:370:7334]", false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)"2001:db8:85a3::8a2e:370:7334", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((Object)"[2001:db8:85a3::8a2e:370:7334]:123", (Object)node.getHostAndPort());
        node = new DruidNode("test/service", null, false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        node = new DruidNode("test/service", null, false, Integer.valueOf(123), Integer.valueOf(123), true, false);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
        node = new DruidNode("test/service", "host", false, Integer.valueOf(123), Integer.valueOf(123), true, false);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
        node = new DruidNode("test/service", "host:123", false, null, Integer.valueOf(123), true, false);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, null, Integer.valueOf(214), true, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)214L, (long)node.getTlsPort());
        node = new DruidNode("test", "host", false, Integer.valueOf(123), Integer.valueOf(214), true, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)214L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, Integer.valueOf(123), Integer.valueOf(214), true, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)214L, (long)node.getTlsPort());
        node = new DruidNode("test", null, false, Integer.valueOf(123), Integer.valueOf(214), true, true);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)214L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, null, Integer.valueOf(214), false, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)214L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, null, Integer.valueOf(123), false, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)123L, (long)node.getTlsPort());
        node = new DruidNode("test", null, false, null, Integer.valueOf(123), false, true);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)123L, (long)node.getTlsPort());
        node = new DruidNode("test", null, false, Integer.valueOf(-1), Integer.valueOf(123), false, true);
        Assert.assertEquals((Object)DruidNode.getDefaultHost(), (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)123L, (long)node.getTlsPort());
        node = new DruidNode("test", "host", false, Integer.valueOf(-1), Integer.valueOf(123), false, true);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)123L, (long)node.getTlsPort());
        node = new DruidNode("test", "host", false, Integer.valueOf(-1), Integer.valueOf(123), true, false);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)-1L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, Integer.valueOf(123), null, true, false);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
        node = new DruidNode("test", "host:123", false, null, Integer.valueOf(123), true, false);
        Assert.assertEquals((Object)"host", (Object)node.getHost());
        Assert.assertEquals((long)123L, (long)node.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)node.getTlsPort());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConflictingPorts() {
        new DruidNode("test/service", "abc:123", false, Integer.valueOf(456), null, true, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAtLeastTlsOrPlainTextIsSet() {
        new DruidNode("test", "host:123", false, null, Integer.valueOf(123), false, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSamePlainTextAndTlsPort() {
        new DruidNode("test", "host:123", false, null, Integer.valueOf(123), true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSamePlainTextAndTlsPort1() {
        new DruidNode("test", "host", false, Integer.valueOf(123), Integer.valueOf(123), true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullTlsPort() {
        new DruidNode("test", "host:123", false, null, null, true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPlainTextAndTlsPort1() {
        new DruidNode("test", "host", false, null, null, true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullTlsPort1() {
        new DruidNode("test", "host:123", false, Integer.valueOf(123), null, true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPlainTextAndTlsPort() {
        new DruidNode("test", null, false, null, null, true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConflictingPlainTextPort() {
        new DruidNode("test", "host:123", false, Integer.valueOf(321), null, true, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIPv6WithPort() {
        new DruidNode("test/service", "[abc:fff]:123", false, Integer.valueOf(456), null, true, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIPv6() {
        new DruidNode("test/service", "abc:fff", false, Integer.valueOf(456), null, true, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConflictingPortsNonsense() {
        new DruidNode("test/service", "[2001:db8:85a3::8a2e:370:7334]:123", false, Integer.valueOf(456), null, true, false);
    }

    @Test
    public void testEquals() {
        String serviceName = "serviceName";
        String host = "some.host";
        int port = 9898;
        Assert.assertEquals((Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false), (Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false));
        Assert.assertNotEquals((Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false), (Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(-1), null, true, false));
        Assert.assertNotEquals((Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false), (Object)new DruidNode("serviceName", "other.host", false, Integer.valueOf(9898), null, true, false));
        Assert.assertNotEquals((Object)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false), (Object)new DruidNode("otherServiceName", "some.host", false, Integer.valueOf(9898), null, true, false));
    }

    @Test
    public void testHashCode() {
        String serviceName = "serviceName";
        String host = "some.host";
        int port = 9898;
        Assert.assertEquals((long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode(), (long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode());
        Assert.assertNotEquals((long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode(), (long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(-1), null, true, false).hashCode());
        Assert.assertNotEquals((long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode(), (long)new DruidNode("serviceName", "other.host", false, Integer.valueOf(9898), null, true, false).hashCode());
        Assert.assertNotEquals((long)new DruidNode("serviceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode(), (long)new DruidNode("otherServiceName", "some.host", false, Integer.valueOf(9898), null, true, false).hashCode());
    }

    @Test
    public void testSerde1() throws Exception {
        DruidNode actual = (DruidNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)new DruidNode("service", "host", true, Integer.valueOf(1234), null, Integer.valueOf(5678), Boolean.valueOf(true), true)), DruidNode.class);
        Assert.assertEquals((Object)"service", (Object)actual.getServiceName());
        Assert.assertEquals((Object)"host", (Object)actual.getHost());
        Assert.assertTrue((boolean)actual.isBindOnHost());
        Assert.assertTrue((boolean)actual.isEnablePlaintextPort());
        Assert.assertTrue((boolean)actual.isEnableTlsPort());
        Assert.assertEquals((long)1234L, (long)actual.getPlaintextPort());
        Assert.assertEquals((long)5678L, (long)actual.getTlsPort());
    }

    @Test
    public void testSerde2() throws Exception {
        DruidNode actual = (DruidNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)new DruidNode("service", "host", false, Integer.valueOf(1234), null, Integer.valueOf(5678), null, false)), DruidNode.class);
        Assert.assertEquals((Object)"service", (Object)actual.getServiceName());
        Assert.assertEquals((Object)"host", (Object)actual.getHost());
        Assert.assertFalse((boolean)actual.isBindOnHost());
        Assert.assertTrue((boolean)actual.isEnablePlaintextPort());
        Assert.assertFalse((boolean)actual.isEnableTlsPort());
        Assert.assertEquals((long)1234L, (long)actual.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)actual.getTlsPort());
    }

    @Test
    public void testSerde3() throws Exception {
        DruidNode actual = (DruidNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)new DruidNode("service", "host", true, Integer.valueOf(1234), null, Integer.valueOf(5678), Boolean.valueOf(false), true)), DruidNode.class);
        Assert.assertEquals((Object)"service", (Object)actual.getServiceName());
        Assert.assertEquals((Object)"host", (Object)actual.getHost());
        Assert.assertTrue((boolean)actual.isBindOnHost());
        Assert.assertFalse((boolean)actual.isEnablePlaintextPort());
        Assert.assertTrue((boolean)actual.isEnableTlsPort());
        Assert.assertEquals((long)-1L, (long)actual.getPlaintextPort());
        Assert.assertEquals((long)5678L, (long)actual.getTlsPort());
    }

    @Test
    public void testDeserialization1() throws Exception {
        String json = "{\n  \"service\":\"service\",\n  \"host\":\"host\",\n  \"bindOnHost\":true,\n  \"plaintextPort\":1234,\n  \"tlsPort\":5678,\n  \"enablePlaintextPort\":true,\n  \"enableTlsPort\":true\n}\n";
        DruidNode actual = (DruidNode)this.mapper.readValue(json, DruidNode.class);
        Assert.assertEquals((Object)new DruidNode("service", "host", true, Integer.valueOf(1234), null, Integer.valueOf(5678), Boolean.valueOf(true), true), (Object)actual);
        Assert.assertEquals((Object)"https", (Object)actual.getServiceScheme());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPort());
        Assert.assertEquals((Object)"host:5678", (Object)actual.getHostAndTlsPort());
        Assert.assertEquals((Object)"host:5678", (Object)actual.getHostAndPortToUse());
    }

    @Test
    public void testDeserialization2() throws Exception {
        String json = "{\n  \"service\":\"service\",\n  \"host\":\"host\",\n  \"plaintextPort\":1234,\n  \"tlsPort\":5678,\n  \"enablePlaintextPort\":true}\n";
        DruidNode actual = (DruidNode)this.mapper.readValue(json, DruidNode.class);
        Assert.assertEquals((Object)new DruidNode("service", "host", false, Integer.valueOf(1234), null, Integer.valueOf(5678), Boolean.valueOf(true), false), (Object)actual);
        Assert.assertEquals((Object)"http", (Object)actual.getServiceScheme());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPort());
        Assert.assertNull((Object)actual.getHostAndTlsPort());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPortToUse());
    }

    @Test
    public void testDeserialization3() throws Exception {
        String json = "{\n  \"service\":\"service\",\n  \"host\":\"host\",\n  \"plaintextPort\":1234,\n  \"tlsPort\":5678}\n";
        DruidNode actual = (DruidNode)this.mapper.readValue(json, DruidNode.class);
        Assert.assertEquals((Object)new DruidNode("service", "host", false, Integer.valueOf(1234), null, Integer.valueOf(5678), null, false), (Object)actual);
        Assert.assertEquals((Object)"http", (Object)actual.getServiceScheme());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPort());
        Assert.assertNull((Object)actual.getHostAndTlsPort());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPortToUse());
    }

    @Test
    public void testDeserialization4() throws Exception {
        String json = "{\n  \"service\":\"service\",\n  \"host\":\"host\",\n  \"port\":1234,\n  \"tlsPort\":5678}\n";
        DruidNode actual = (DruidNode)this.mapper.readValue(json, DruidNode.class);
        Assert.assertEquals((Object)new DruidNode("service", "host", false, null, Integer.valueOf(1234), Integer.valueOf(5678), null, false), (Object)actual);
        Assert.assertEquals((Object)"http", (Object)actual.getServiceScheme());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPort());
        Assert.assertNull((Object)actual.getHostAndTlsPort());
        Assert.assertEquals((Object)"host:1234", (Object)actual.getHostAndPortToUse());
    }
}

