/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.server;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import java.io.ByteArrayInputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ReadListener;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.org.apache.druid.client.selector.Server;
import org.apache.hive.druid.org.apache.druid.common.utils.SocketUtil;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.Jerseys;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Smile;
import org.apache.hive.druid.org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.hive.druid.org.apache.druid.initialization.Initialization;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.server.AsyncQueryForwardingServlet;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.hive.druid.org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.hive.druid.org.apache.druid.server.log.NoopRequestLogger;
import org.apache.hive.druid.org.apache.druid.server.log.RequestLogger;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.server.router.AvaticaConnectionBalancer;
import org.apache.hive.druid.org.apache.druid.server.router.QueryHostFinder;
import org.apache.hive.druid.org.apache.druid.server.router.RendezvousHashAvaticaConnectionBalancer;
import org.apache.hive.druid.org.apache.druid.server.security.AllowAllAuthorizer;
import org.apache.hive.druid.org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.hive.druid.org.apache.druid.server.security.Authorizer;
import org.apache.hive.druid.org.apache.druid.server.security.AuthorizerMapper;
import org.easymock.EasyMock;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncQueryForwardingServletTest
extends BaseJettyTest {
    private static int port1;
    private static int port2;

    @Override
    @Before
    public void setup() throws Exception {
        AsyncQueryForwardingServletTest.setProperties();
        Injector injector = this.setupInjector();
        DruidNode node = (DruidNode)injector.getInstance(Key.get(DruidNode.class, Self.class));
        this.port = node.getPlaintextPort();
        port1 = SocketUtil.findOpenPortFrom((int)(this.port + 1));
        port2 = SocketUtil.findOpenPortFrom((int)(port1 + 1));
        this.lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        this.lifecycle.start();
        BaseJettyTest.ClientHolder holder = (BaseJettyTest.ClientHolder)injector.getInstance(BaseJettyTest.ClientHolder.class);
        this.client = holder.getClient();
    }

    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", false, null, null, true, false));
                binder.bind(JettyServerInitializer.class).to(ProxyJettyServerInit.class).in(LazySingleton.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)new AuthorizerMapper(null){

                    public Authorizer getAuthorizer(String name) {
                        return new AllowAllAuthorizer();
                    }
                });
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                LifecycleModule.register((Binder)binder, org.eclipse.jetty.server.Server.class);
            }
        }));
    }

    @Test
    public void testProxyGzipCompression() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/proxy/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("Accept-Encoding", "gzip");
        Assert.assertEquals((Object)"gzip", (Object)get.getContentEncoding());
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestProperty("Accept-Encoding", "gzip");
        post.setRequestMethod("POST");
        Assert.assertEquals((Object)"gzip", (Object)post.getContentEncoding());
        HttpURLConnection getNoGzip = (HttpURLConnection)url.openConnection();
        Assert.assertNotEquals((Object)"gzip", (Object)getNoGzip.getContentEncoding());
        HttpURLConnection postNoGzip = (HttpURLConnection)url.openConnection();
        postNoGzip.setRequestMethod("POST");
        Assert.assertNotEquals((Object)"gzip", (Object)postNoGzip.getContentEncoding());
    }

    @Test(timeout=60000L)
    public void testDeleteBroadcast() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        AsyncQueryForwardingServletTest.makeTestDeleteServer(port1, latch).start();
        AsyncQueryForwardingServletTest.makeTestDeleteServer(port2, latch).start();
        URL url = new URL("http://localhost:" + this.port + "/druid/v2/abc123");
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestMethod("DELETE");
        int code = post.getResponseCode();
        Assert.assertEquals((long)200L, (long)code);
        latch.await();
    }

    @Test
    public void testQueryProxy() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/P1D").granularity(Granularities.ALL).context((Map)ImmutableMap.of((Object)"queryId", (Object)"dummy")).build();
        QueryHostFinder hostFinder = (QueryHostFinder)EasyMock.createMock(QueryHostFinder.class);
        EasyMock.expect((Object)hostFinder.pickServer((Query)query)).andReturn((Object)new TestServer("http", "1.2.3.4", 9999)).once();
        EasyMock.replay((Object[])new Object[]{hostFinder});
        HttpServletRequest requestMock = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonMapper.writeValueAsBytes((Object)query));
        ServletInputStream servletInputStream = new ServletInputStream(){
            private boolean finished;

            public boolean isFinished() {
                return this.finished;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                int b = inputStream.read();
                if (b < 0) {
                    this.finished = true;
                }
                return b;
            }
        };
        EasyMock.expect((Object)requestMock.getContentType()).andReturn((Object)"application/json").times(2);
        requestMock.setAttribute("org.apache.hive.druid.org.apache.druid.proxy.objectMapper", (Object)jsonMapper);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)requestMock.getRequestURI()).andReturn((Object)"/druid/v2/");
        EasyMock.expect((Object)requestMock.getMethod()).andReturn((Object)"POST");
        EasyMock.expect((Object)requestMock.getInputStream()).andReturn((Object)servletInputStream);
        requestMock.setAttribute("org.apache.hive.druid.org.apache.druid.proxy.query", (Object)query);
        requestMock.setAttribute("org.apache.hive.druid.org.apache.druid.proxy.to.host", (Object)"1.2.3.4:9999");
        requestMock.setAttribute("org.apache.hive.druid.org.apache.druid.proxy.to.host.scheme", (Object)"http");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{requestMock});
        final AtomicLong didService = new AtomicLong();
        AsyncQueryForwardingServlet servlet = new AsyncQueryForwardingServlet((QueryToolChestWarehouse)new MapQueryToolChestWarehouse((Map)ImmutableMap.of()), jsonMapper, TestHelper.makeSmileMapper(), hostFinder, null, null, new NoopServiceEmitter(), (RequestLogger)new NoopRequestLogger(), (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), new AuthenticatorMapper((Map)ImmutableMap.of())){

            protected void doService(HttpServletRequest request, HttpServletResponse response) {
                didService.incrementAndGet();
            }
        };
        servlet.service(requestMock, null);
        EasyMock.verify((Object[])new Object[]{hostFinder, requestMock});
        Assert.assertEquals((long)1L, (long)didService.get());
    }

    private static org.eclipse.jetty.server.Server makeTestDeleteServer(int port, final CountDownLatch latch) {
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server(port);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(new ServletHolder((Servlet)new HttpServlet(){

            protected void doDelete(HttpServletRequest req, HttpServletResponse resp) {
                latch.countDown();
                resp.setStatus(200);
            }
        }), "/default/*");
        server.setHandler((Handler)handler);
        return server;
    }

    @Test
    public void testRewriteURI() {
        Assert.assertEquals((Object)"http://localhost:1234/some/path?param=1", (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost:1234", (String)"/some/path", (String)"param=1"));
        Assert.assertEquals((Object)"http://[2a00:1450:4007:805::1007]:1234/some/path?param=1&param2=%E2%82%AC", (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)HostAndPort.fromParts((String)"2a00:1450:4007:805::1007", (int)1234).toString(), (String)"/some/path", (String)"param=1&param2=%E2%82%AC"));
        Assert.assertEquals((Object)"http://localhost/", (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost", (String)"/", null));
        Assert.assertEquals((Object)"http://localhost:1234/some/path?intervals=1900-01-01T00%3A00%3A00.000%2B01%3A00%2F3000-01-01T00%3A00%3A00.000%2B01%3A00", (Object)AsyncQueryForwardingServlet.makeURI((String)"http", (String)"localhost:1234", (String)"/some/path", (String)"intervals=1900-01-01T00%3A00%3A00.000%2B01%3A00%2F3000-01-01T00%3A00%3A00.000%2B01%3A00"));
    }

    private static class TestServer
    implements Server {
        private final String scheme;
        private final String address;
        private final int port;

        public TestServer(String scheme, String address, int port) {
            this.scheme = scheme;
            this.address = address;
            this.port = port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHost() {
            return this.address + ":" + this.port;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class ProxyJettyServerInit
    implements JettyServerInitializer {
        private final DruidNode node;

        @Inject
        public ProxyJettyServerInit(@Self DruidNode node) {
            this.node = node;
        }

        public void initialize(org.eclipse.jetty.server.Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            QueryHostFinder hostFinder = new QueryHostFinder(null, (AvaticaConnectionBalancer)new RendezvousHashAvaticaConnectionBalancer()){

                public Server pickServer(Query query) {
                    return new TestServer("http", "localhost", node.getPlaintextPort());
                }

                public Server pickDefaultServer() {
                    return new TestServer("http", "localhost", node.getPlaintextPort());
                }

                public Collection<Server> getAllServers() {
                    return ImmutableList.of((Object)new TestServer("http", "localhost", node.getPlaintextPort()), (Object)new TestServer("http", "localhost", port1), (Object)new TestServer("http", "localhost", port2));
                }
            };
            ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
            ServletHolder holder = new ServletHolder((Servlet)new AsyncQueryForwardingServlet((QueryToolChestWarehouse)new MapQueryToolChestWarehouse((Map)ImmutableMap.of()), jsonMapper, (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Smile.class)), hostFinder, injector.getProvider(HttpClient.class), (DruidHttpClientConfig)injector.getInstance(DruidHttpClientConfig.class), new NoopServiceEmitter(), (RequestLogger)new NoopRequestLogger(), (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), new AuthenticatorMapper((Map)ImmutableMap.of())){

                protected String rewriteURI(HttpServletRequest request, String scheme, String host) {
                    String uri = super.rewriteURI(request, scheme, host);
                    if (uri.contains("/druid/v2")) {
                        return URI.create(StringUtils.replace((String)uri, (String)"/druid/v2", (String)"/default")).toString();
                    }
                    return URI.create(StringUtils.replace((String)uri, (String)"/proxy", (String)"")).toString();
                }
            });
            holder.setInitParameter("maxThreads", "256");
            root.addServlet(holder, "/proxy/*");
            root.addServlet(holder, "/druid/v2/*");
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            root.addFilter(GuiceFilter.class, "/slow/*", null);
            root.addFilter(GuiceFilter.class, "/default/*", null);
            root.addFilter(GuiceFilter.class, "/exception/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)4096, (int)-1)});
            server.setHandler((Handler)handlerList);
        }
    }
}

