/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.extraction.BucketExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionVirtualColumnTest
extends InitializedNullHandlingTest {
    private static final InputRow ROW0 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T00:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of());
    private static final InputRow ROW1 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T00:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)4));
    private static final InputRow ROW2 = new MapBasedInputRow(DateTimes.of((String)"2000-01-01T02:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)2.1, (Object)"y", (Object)3L, (Object)"z", (Object)"foobar"));
    private static final InputRow ROW3 = new MapBasedInputRow(DateTimes.of((String)"2000-01-02T01:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)2L, (Object)"y", (Object)3L, (Object)"z", (Object)"foobar"));
    private static final InputRow ROWMULTI = new MapBasedInputRow(DateTimes.of((String)"2000-01-02T01:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)2L, (Object)"y", (Object)3L, (Object)"a", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)"b", (Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), (Object)"c", (Object)ImmutableList.of((Object)"4", (Object)"5", (Object)"6")));
    private static final InputRow ROWMULTI2 = new MapBasedInputRow(DateTimes.of((String)"2000-01-02T01:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)3L, (Object)"y", (Object)4L, (Object)"a", (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"), (Object)"b", (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"), (Object)"c", (Object)ImmutableList.of((Object)"7", (Object)"8", (Object)"9")));
    private static final InputRow ROWMULTI3 = new MapBasedInputRow(DateTimes.of((String)"2000-01-02T01:00:00").getMillis(), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"x", (Object)3L, (Object)"y", (Object)4L, (Object)"b", Arrays.asList("3", null, "5")));
    private static final ExpressionVirtualColumn X_PLUS_Y = new ExpressionVirtualColumn("expr", "x + y", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn CONSTANT_LIKE = new ExpressionVirtualColumn("expr", "like('foo', 'f%')", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn CONSTANT_NULL_ARITHMETIC = new ExpressionVirtualColumn("expr", "2.1 + null", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn Z_LIKE = new ExpressionVirtualColumn("expr", "like(z, 'f%')", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn Z_CONCAT_X = new ExpressionVirtualColumn("expr", "z + cast(x, 'string')", ValueType.STRING, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn Z_CONCAT_NONEXISTENT = new ExpressionVirtualColumn("expr", "concat(z, nonexistent)", ValueType.STRING, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn TIME_FLOOR = new ExpressionVirtualColumn("expr", "timestamp_floor(__time, 'P1D')", ValueType.LONG, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn SCALE_LONG = new ExpressionVirtualColumn("expr", "x * 2", ValueType.LONG, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn SCALE_FLOAT = new ExpressionVirtualColumn("expr", "x * 2", ValueType.FLOAT, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn SCALE_LIST_IMPLICIT = new ExpressionVirtualColumn("expr", "b * 2", ValueType.STRING, TestExprMacroTable.INSTANCE);
    private static final ExpressionVirtualColumn SCALE_LIST_EXPLICIT = new ExpressionVirtualColumn("expr", "map(b -> b * 2, b)", ValueType.STRING, TestExprMacroTable.INSTANCE);
    private static final ThreadLocal<Row> CURRENT_ROW = new ThreadLocal();
    private static final ColumnSelectorFactory COLUMN_SELECTOR_FACTORY = RowBasedColumnSelectorFactory.create(CURRENT_ROW::get, null);

    @Test
    public void testObjectSelector() {
        ColumnValueSelector selector = X_PLUS_Y.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals(null, (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)4.0, (Object)selector.getObject());
        } else {
            Assert.assertEquals(null, (Object)selector.getObject());
        }
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)5.1, (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)5L, (Object)selector.getObject());
    }

    @Test
    public void testMultiObjectSelector() {
        DefaultDimensionSpec spec = new DefaultDimensionSpec("expr", "expr");
        DimensionSelector selectorImplicit = SCALE_LIST_IMPLICIT.makeDimensionSelector((DimensionSpec)spec, COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROWMULTI);
        Assert.assertEquals((Object)ImmutableList.of((Object)"2.0", (Object)"4.0", (Object)"6.0"), (Object)selectorImplicit.getObject());
        CURRENT_ROW.set((Row)ROWMULTI2);
        Assert.assertEquals((Object)ImmutableList.of((Object)"6.0", (Object)"8.0", (Object)"10.0"), (Object)selectorImplicit.getObject());
        CURRENT_ROW.set((Row)ROWMULTI3);
        Assert.assertEquals(Arrays.asList("6.0", NullHandling.replaceWithDefault() ? "0.0" : null, "10.0"), (Object)selectorImplicit.getObject());
        DimensionSelector selectorExplicit = SCALE_LIST_EXPLICIT.makeDimensionSelector((DimensionSpec)spec, COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROWMULTI);
        Assert.assertEquals((Object)ImmutableList.of((Object)"2.0", (Object)"4.0", (Object)"6.0"), (Object)selectorExplicit.getObject());
        CURRENT_ROW.set((Row)ROWMULTI2);
        Assert.assertEquals((Object)ImmutableList.of((Object)"6.0", (Object)"8.0", (Object)"10.0"), (Object)selectorExplicit.getObject());
        CURRENT_ROW.set((Row)ROWMULTI3);
        Assert.assertEquals(Arrays.asList("6.0", NullHandling.replaceWithDefault() ? "0.0" : null, "10.0"), (Object)selectorExplicit.getObject());
    }

    @Test
    public void testLongSelector() {
        ColumnValueSelector selector = X_PLUS_Y.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)0L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)4L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)5L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)5L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorUsingStringFunction() {
        ColumnValueSelector selector = Z_CONCAT_X.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)0L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)4L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW2);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)0L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW3);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)0L, (long)selector.getLong());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
    }

    @Test
    public void testFloatSelector() {
        ColumnValueSelector selector = X_PLUS_Y.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)4.0f, (float)selector.getFloat(), (float)0.0f);
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((float)5.1f, (float)selector.getFloat(), (float)0.0f);
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((float)5.0f, (float)selector.getFloat(), (float)0.0f);
    }

    @Test
    public void testDimensionSelector() {
        DimensionSelector selector = X_PLUS_Y.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        ValueMatcher nullMatcher = selector.makeValueMatcher((String)null);
        ValueMatcher fiveMatcher = selector.makeValueMatcher("5");
        ValueMatcher nonNullMatcher = selector.makeValueMatcher(Predicates.notNull());
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
            Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
            Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
            Assert.assertEquals((Object)"4.0", (Object)selector.lookupName(selector.getRow().get(0)));
        } else {
            Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
            Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
            Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
            Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        }
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5.1", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testNullDimensionSelector() {
        DimensionSelector selector = X_PLUS_Y.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        ValueMatcher nonNullMatcher = selector.makeValueMatcher(Predicates.notNull());
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
    }

    @Test
    public void testDimensionSelectorUsingStringFunction() {
        DimensionSelector selector = Z_CONCAT_X.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        Assert.assertNotNull((Object)selector);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "4" : null), (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)"foobar2.1", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)"foobar2", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testDimensionSelectorUsingNonexistentColumn() {
        DimensionSelector selector = Z_CONCAT_NONEXISTENT.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec("expr", "expr"), COLUMN_SELECTOR_FACTORY);
        Assert.assertNotNull((Object)selector);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertNull((Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertNull((Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "foobar" : null), (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)1L, (long)selector.getRow().size());
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? "foobar" : null), (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testDimensionSelectorWithExtraction() {
        DimensionSelector selector = X_PLUS_Y.makeDimensionSelector((DimensionSpec)new ExtractionDimensionSpec("expr", "x", (ExtractionFn)new BucketExtractionFn(Double.valueOf(1.0), Double.valueOf(0.0))), COLUMN_SELECTOR_FACTORY);
        ValueMatcher nullMatcher = selector.makeValueMatcher((String)null);
        ValueMatcher fiveMatcher = selector.makeValueMatcher("5");
        ValueMatcher nonNullMatcher = selector.makeValueMatcher(Predicates.notNull());
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
        Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW1);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
            Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
            Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
            Assert.assertEquals((Object)"4.0", (Object)selector.lookupName(selector.getRow().get(0)));
        } else {
            Assert.assertEquals((Object)true, (Object)nullMatcher.matches());
            Assert.assertEquals((Object)false, (Object)fiveMatcher.matches());
            Assert.assertEquals((Object)false, (Object)nonNullMatcher.matches());
            Assert.assertEquals(null, (Object)selector.lookupName(selector.getRow().get(0)));
        }
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5.1", (Object)selector.lookupName(selector.getRow().get(0)));
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((Object)false, (Object)nullMatcher.matches());
        Assert.assertEquals((Object)true, (Object)fiveMatcher.matches());
        Assert.assertEquals((Object)true, (Object)nonNullMatcher.matches());
        Assert.assertEquals((Object)"5", (Object)selector.lookupName(selector.getRow().get(0)));
    }

    @Test
    public void testLongSelectorWithConstantLikeExprMacro() {
        ColumnValueSelector selector = CONSTANT_LIKE.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)1L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorWithConstantNullArithmetic() {
        ColumnValueSelector selector = CONSTANT_NULL_ARITHMETIC.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)2L, (long)selector.getLong());
            Assert.assertFalse((boolean)selector.isNull());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
    }

    @Test
    public void testFloatSelectorWithConstantNullArithmetic() {
        ColumnValueSelector selector = CONSTANT_NULL_ARITHMETIC.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)2.1f, (float)selector.getFloat(), (float)0.0f);
            Assert.assertFalse((boolean)selector.isNull());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
        }
    }

    @Test
    public void testExprEvalSelectorWithConstantNullArithmetic() {
        ColumnValueSelector selector = ExpressionSelectors.makeExprEvalSelector((ColumnSelectorFactory)COLUMN_SELECTOR_FACTORY, (Expr)Parser.parse((String)CONSTANT_NULL_ARITHMETIC.getExpression(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)2.1f, (float)selector.getFloat(), (float)0.0f);
            Assert.assertFalse((boolean)selector.isNull());
            Assert.assertEquals((double)2.1, (double)((ExprEval)selector.getObject()).asDouble(), (double)0.0);
        } else {
            Assert.assertTrue((boolean)selector.isNull());
            Assert.assertTrue((boolean)((ExprEval)selector.getObject()).isNumericNull());
        }
    }

    @Test
    public void testLongSelectorWithZLikeExprMacro() {
        ColumnValueSelector selector = Z_LIKE.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)0L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)1L, (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)1L, (long)selector.getLong());
    }

    @Test
    public void testLongSelectorOfTimeColumn() {
        ColumnValueSelector selector = TIME_FLOOR.makeColumnValueSelector("expr", COLUMN_SELECTOR_FACTORY);
        CURRENT_ROW.set((Row)ROW0);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        Assert.assertEquals((float)DateTimes.of((String)"2000-01-01").getMillis(), (float)selector.getFloat(), (float)0.0f);
        Assert.assertEquals((double)DateTimes.of((String)"2000-01-01").getMillis(), (double)selector.getDouble(), (double)0.0);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01").getMillis(), (Object)selector.getObject());
        CURRENT_ROW.set((Row)ROW1);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW2);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)selector.getLong());
        CURRENT_ROW.set((Row)ROW3);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-02").getMillis(), (long)selector.getLong());
        Assert.assertEquals((double)DateTimes.of((String)"2000-01-02").getMillis(), (double)selector.getDouble(), (double)0.0);
    }

    @Test
    public void testRequiredColumns() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)X_PLUS_Y.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)CONSTANT_LIKE.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)"z"), (Object)Z_LIKE.requiredColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)"x", (Object)"z"), (Object)Z_CONCAT_X.requiredColumns());
    }

    @Test
    public void testExprEvalSelectorWithLongsAndNulls() {
        ColumnValueSelector selector = ExpressionSelectors.makeExprEvalSelector((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create(CURRENT_ROW::get, (Map)ImmutableMap.of((Object)"x", (Object)ValueType.LONG)), (Expr)Parser.parse((String)SCALE_LONG.getExpression(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)0.0f, (float)selector.getLong(), (float)0.0f);
            Assert.assertFalse((boolean)selector.isNull());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
            Assert.assertTrue((boolean)((ExprEval)selector.getObject()).isNumericNull());
        }
    }

    @Test
    public void testExprEvalSelectorWithDoublesAndNulls() {
        ColumnValueSelector selector = ExpressionSelectors.makeExprEvalSelector((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create(CURRENT_ROW::get, (Map)ImmutableMap.of((Object)"x", (Object)ValueType.DOUBLE)), (Expr)Parser.parse((String)SCALE_FLOAT.getExpression(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((double)0.0, (double)selector.getDouble(), (double)0.0);
            Assert.assertFalse((boolean)selector.isNull());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
            Assert.assertTrue((boolean)((ExprEval)selector.getObject()).isNumericNull());
        }
    }

    @Test
    public void testExprEvalSelectorWithFloatAndNulls() {
        ColumnValueSelector selector = ExpressionSelectors.makeExprEvalSelector((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create(CURRENT_ROW::get, (Map)ImmutableMap.of((Object)"x", (Object)ValueType.FLOAT)), (Expr)Parser.parse((String)SCALE_FLOAT.getExpression(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        CURRENT_ROW.set((Row)ROW0);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((float)0.0f, (float)selector.getFloat(), (float)0.0f);
            Assert.assertFalse((boolean)selector.isNull());
        } else {
            Assert.assertTrue((boolean)selector.isNull());
            Assert.assertTrue((boolean)((ExprEval)selector.getObject()).isNumericNull());
        }
    }
}

