/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.common.guava.SettableSupplier;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprEval;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.TestObjectColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionSelectors;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionColumnValueSelectorTest {
    @Test
    public void testSupplierFromDimensionSelector() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromDimensionSelector((DimensionSelector)ExpressionColumnValueSelectorTest.dimensionSelectorFromSupplier((Supplier<String>)settableSupplier), (boolean)false);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set(null);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorObject() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, Object.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
        settableSupplier.set((Object)"1.234");
        Assert.assertEquals((Object)"1.234", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorNumber() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, Number.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorString() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, String.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1.1");
        Assert.assertEquals((Object)"1.1", (Object)supplier.get());
        settableSupplier.set((Object)"1");
        Assert.assertEquals((Object)"1", (Object)supplier.get());
    }

    @Test
    public void testSupplierFromObjectSelectorList() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionColumnValueSelectorTest.objectSelectorFromSupplier(settableSupplier, List.class));
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])supplier.get()));
    }

    @Test
    public void testCoerceListToArray() {
        ImmutableList longList = ImmutableList.of((Object)1L, (Object)2L, (Object)3L);
        Assert.assertArrayEquals((Object[])new Long[]{1L, 2L, 3L}, (Object[])((Long[])ExpressionSelectors.coerceListToArray((List)longList)));
        ImmutableList intList = ImmutableList.of((Object)1, (Object)2, (Object)3);
        Assert.assertArrayEquals((Object[])new Long[]{1L, 2L, 3L}, (Object[])((Long[])ExpressionSelectors.coerceListToArray((List)intList)));
        ImmutableList floatList = ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f));
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0, 3.0}, (Object[])((Double[])ExpressionSelectors.coerceListToArray((List)floatList)));
        ImmutableList doubleList = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0, 3.0}, (Object[])((Double[])ExpressionSelectors.coerceListToArray((List)doubleList)));
        ImmutableList stringList = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((String[])ExpressionSelectors.coerceListToArray((List)stringList)));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        Assert.assertArrayEquals((Object[])new String[]{"a", null, "c"}, (Object[])((String[])ExpressionSelectors.coerceListToArray(withNulls)));
        ArrayList<Long> withNumberNulls = new ArrayList<Long>();
        withNumberNulls.add(1L);
        withNumberNulls.add(null);
        withNumberNulls.add(3L);
        Assert.assertArrayEquals((Object[])new Long[]{1L, null, 3L}, (Object[])((Long[])ExpressionSelectors.coerceListToArray(withNumberNulls)));
        ImmutableList withStringMix = ImmutableList.of((Object)1L, (Object)"b", (Object)3L);
        Assert.assertArrayEquals((Object[])new String[]{"1", "b", "3"}, (Object[])((String[])ExpressionSelectors.coerceListToArray((List)withStringMix)));
        ImmutableList withIntsAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)3);
        Assert.assertArrayEquals((Object[])new Long[]{1L, 2L, 3L}, (Object[])((Long[])ExpressionSelectors.coerceListToArray((List)withIntsAndLongs)));
        ImmutableList withFloatsAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)Float.valueOf(3.0f));
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0, 3.0}, (Object[])((Double[])ExpressionSelectors.coerceListToArray((List)withFloatsAndLongs)));
        ImmutableList withDoublesAndLongs = ImmutableList.of((Object)1, (Object)2L, (Object)3.0);
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0, 3.0}, (Object[])((Double[])ExpressionSelectors.coerceListToArray((List)withDoublesAndLongs)));
        ImmutableList withFloatsAndDoubles = ImmutableList.of((Object)1L, (Object)Float.valueOf(2.0f), (Object)3.0);
        Assert.assertArrayEquals((Object[])new Double[]{1.0, 2.0, 3.0}, (Object[])((Double[])ExpressionSelectors.coerceListToArray((List)withFloatsAndDoubles)));
        ArrayList<Object> withAllNulls = new ArrayList<Object>();
        withAllNulls.add(null);
        withAllNulls.add(null);
        withAllNulls.add(null);
        Assert.assertArrayEquals((Object[])new String[]{null, null, null}, (Object[])((String[])ExpressionSelectors.coerceListToArray(withAllNulls)));
    }

    @Test
    public void testCoerceExprToValue() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofLongArray((Long[])new Long[]{1L, 2L, 3L})));
        Assert.assertEquals((Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofDoubleArray((Double[])new Double[]{1.0, 2.0, 3.0})));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofStringArray((String[])new String[]{"a", "b", "c"})));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        Assert.assertEquals(withNulls, (Object)ExpressionSelectors.coerceEvalToSelectorObject((ExprEval)ExprEval.ofStringArray((String[])new String[]{"a", null, "c"})));
    }

    private static DimensionSelector dimensionSelectorFromSupplier(final Supplier<String> supplier) {
        return new BaseSingleValueDimensionSelector(){

            protected String getValue() {
                return (String)supplier.get();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("supplier", (Object)supplier);
            }
        };
    }

    private static <T> ColumnValueSelector<T> objectSelectorFromSupplier(final Supplier<T> supplier, final Class<T> clazz) {
        return new TestObjectColumnSelector<T>(){

            public Class<T> classOfObject() {
                return clazz;
            }

            public T getObject() {
                return supplier.get();
            }
        };
    }
}

