/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.groupby.ResultRow;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.TestIndex;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.virtual.DummyStringVirtualColumn;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class DummyStringVirtualColumnTest
extends InitializedNullHandlingTest {
    private static final String VSTRING_DIM = "vstring";
    private static final String COUNT = "count";
    private final List<Segment> mmappedSegments;
    private final List<Segment> inMemorySegments;
    private final List<Segment> mixedSegments;
    private final AggregationTestHelper topNTestHelper;
    private final AggregationTestHelper groupByTestHelper;

    public DummyStringVirtualColumnTest() {
        QueryableIndexSegment queryableIndexSegment = new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"testing"));
        IncrementalIndexSegment incrementalIndexSegment = new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"testing"));
        this.mmappedSegments = Lists.newArrayList((Object[])new Segment[]{queryableIndexSegment, queryableIndexSegment});
        this.inMemorySegments = Lists.newArrayList((Object[])new Segment[]{incrementalIndexSegment, incrementalIndexSegment});
        this.mixedSegments = Lists.newArrayList((Object[])new Segment[]{incrementalIndexSegment, queryableIndexSegment});
        this.topNTestHelper = AggregationTestHelper.createTopNQueryAggregationTestHelper(Collections.EMPTY_LIST, null);
        this.groupByTestHelper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Collections.EMPTY_LIST, new GroupByQueryConfig(), null);
    }

    @Test
    public void testGroupByWithMMappedSegments() {
        this.testGroupBy(this.mmappedSegments, true, true);
        this.testGroupBy(this.mmappedSegments, true, false);
        this.testGroupBy(this.mmappedSegments, false, true);
    }

    @Test
    public void testGroupByWithInMemorySegments() {
        this.testGroupBy(this.inMemorySegments, true, true);
        this.testGroupBy(this.inMemorySegments, true, false);
        try {
            this.testGroupBy(this.inMemorySegments, false, true);
            Assert.fail((String)"must need row based methods");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWithMixedSegments() {
        this.testGroupBy(this.mixedSegments, true, true);
        this.testGroupBy(this.mixedSegments, true, false);
        try {
            this.testGroupBy(this.mixedSegments, false, true);
            Assert.fail((String)"must need row based methods");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWithSelectFilterWithMMappedSegments() {
        this.testGroupByWithSelectFilter(this.mmappedSegments, true, false, false, false);
        this.testGroupByWithSelectFilter(this.mmappedSegments, true, false, true, true);
        this.testGroupByWithSelectFilter(this.mmappedSegments, false, true, true, true);
        this.testGroupByWithSelectFilter(this.mmappedSegments, true, true, true, false);
    }

    @Test
    public void testGroupByWithSelectFilterWithInMemorySegments() {
        this.testGroupByWithSelectFilter(this.inMemorySegments, true, false, false, false);
        this.testGroupByWithSelectFilter(this.inMemorySegments, true, true, true, false);
        try {
            this.testGroupByWithSelectFilter(this.inMemorySegments, true, true, true, true);
            Assert.fail((String)"value matchers must be required");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWithSelectFilterWithMixedSegments() {
        this.testGroupByWithSelectFilter(this.mixedSegments, true, false, false, false);
        this.testGroupByWithSelectFilter(this.mixedSegments, true, true, true, false);
        try {
            this.testGroupByWithSelectFilter(this.mixedSegments, true, true, true, true);
            Assert.fail((String)"value matchers must be required");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWithRegexFilterWithMMappedSegments() {
        this.testGroupByWithRegexFilter(this.mmappedSegments, true, false, false, false);
        this.testGroupByWithRegexFilter(this.mmappedSegments, true, false, true, true);
        this.testGroupByWithRegexFilter(this.mmappedSegments, false, true, true, true);
        this.testGroupByWithRegexFilter(this.mmappedSegments, true, true, true, false);
    }

    @Test
    public void testGroupByWithRegexFilterWithInMemorySegments() {
        this.testGroupByWithRegexFilter(this.inMemorySegments, true, false, false, false);
        this.testGroupByWithRegexFilter(this.inMemorySegments, true, true, true, false);
        try {
            this.testGroupByWithRegexFilter(this.inMemorySegments, true, true, true, true);
            Assert.fail((String)"value matchers must be required");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGroupByWithRegexFilterWithMixedSegments() {
        this.testGroupByWithRegexFilter(this.mixedSegments, true, false, false, false);
        this.testGroupByWithRegexFilter(this.mixedSegments, true, true, true, false);
        try {
            this.testGroupByWithRegexFilter(this.mixedSegments, true, true, true, true);
            Assert.fail((String)"value matchers must be required");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTopNWithMMappedSegments() {
        this.testTopN(this.mmappedSegments, true, true);
        this.testTopN(this.mmappedSegments, true, false);
        this.testTopN(this.mmappedSegments, false, true);
    }

    @Test
    public void testTopNWithInMemorySegments() {
        this.testTopN(this.inMemorySegments, true, true);
        this.testTopN(this.inMemorySegments, true, false);
        try {
            this.testTopN(this.inMemorySegments, false, true);
            Assert.fail((String)"must need row based methods");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTopNWithMixedSegments() {
        this.testTopN(this.mixedSegments, true, true);
        this.testTopN(this.mixedSegments, true, false);
        try {
            this.testTopN(this.mixedSegments, false, true);
            Assert.fail((String)"must need row based methods");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testGroupBy(List<Segment> segments, boolean enableRowBasedMethods, boolean enableColumnBasedMethods) {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new DummyStringVirtualColumn("market", VSTRING_DIM, enableRowBasedMethods, enableColumnBasedMethods, false, true)}).addDimension(VSTRING_DIM).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).setInterval("2000/2030").addOrderByColumn(VSTRING_DIM).build();
        List rows = this.groupByTestHelper.runQueryOnSegmentsObjs(segments, (Query)query).toList();
        List<ResultRow> expectedRows = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 1674L, VSTRING_DIM, "spot"), GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 372L, VSTRING_DIM, "total_market"), GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 372L, VSTRING_DIM, "upfront"));
        TestHelper.assertExpectedObjects(expectedRows, rows, "failed");
    }

    private void testGroupByWithSelectFilter(List<Segment> segments, boolean enableRowBasedMethods, boolean enableColumnBasedMethods, boolean enableBitmaps, boolean disableValueMatchers) {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new DummyStringVirtualColumn("market", VSTRING_DIM, enableRowBasedMethods, enableColumnBasedMethods, enableBitmaps, disableValueMatchers)}).addDimension(VSTRING_DIM).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).setInterval("2000/2030").addOrderByColumn(VSTRING_DIM).setDimFilter((DimFilter)new SelectorDimFilter(VSTRING_DIM, "spot", null)).build();
        List rows = this.groupByTestHelper.runQueryOnSegmentsObjs(segments, (Query)query).toList();
        List<ResultRow> expectedRows = Collections.singletonList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 1674L, VSTRING_DIM, "spot"));
        TestHelper.assertExpectedObjects(expectedRows, rows, "failed");
    }

    private void testGroupByWithRegexFilter(List<Segment> segments, boolean enableRowBasedMethods, boolean enableColumnBasedMethods, boolean enableBitmaps, boolean disableValueMatchers) {
        GroupByQuery query = new GroupByQuery.Builder().setDataSource("testing").setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new DummyStringVirtualColumn("market", VSTRING_DIM, enableRowBasedMethods, enableColumnBasedMethods, enableBitmaps, disableValueMatchers)}).addDimension(VSTRING_DIM).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).setInterval("2000/2030").addOrderByColumn(VSTRING_DIM).setDimFilter((DimFilter)new RegexDimFilter(VSTRING_DIM, "(spot)|(upfront)", null)).build();
        List rows = this.groupByTestHelper.runQueryOnSegmentsObjs(segments, (Query)query).toList();
        List<ResultRow> expectedRows = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 1674L, VSTRING_DIM, "spot"), GroupByQueryRunnerTestHelper.createExpectedRow(query, "2000", COUNT, 372L, VSTRING_DIM, "upfront"));
        TestHelper.assertExpectedObjects(expectedRows, rows, "failed");
    }

    private void testTopN(List<Segment> segments, boolean enableRowBasedMethods, boolean enableColumnBasedMethods) {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(Granularities.ALL).dimension(VSTRING_DIM).metric(COUNT).threshold(1).aggregators(new AggregatorFactory[]{new CountAggregatorFactory(COUNT)}).virtualColumns(new VirtualColumn[]{new DummyStringVirtualColumn("market", VSTRING_DIM, enableRowBasedMethods, enableColumnBasedMethods, false, true)}).intervals("2000/2030").build();
        List rows = this.topNTestHelper.runQueryOnSegmentsObjs(segments, (Query)query).toList();
        List expectedRows = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)COUNT, (Object)1674L).put((Object)VSTRING_DIM, (Object)"spot").build()))));
        TestHelper.assertExpectedResults(expectedRows, rows, "failed");
    }
}

