/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.virtual;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.IdLookup;
import org.apache.hive.druid.org.apache.druid.segment.NilColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.BaseColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnHolder;
import org.apache.hive.druid.org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.historical.HistoricalDimensionSelector;

public class DummyStringVirtualColumn
implements VirtualColumn {
    private final String baseColumnName;
    private final String outputName;
    private final boolean enableRowBasedMethods;
    private final boolean enableColumnBasedMethods;
    private final boolean enableBitmaps;
    private final boolean disableValueMatchers;

    public DummyStringVirtualColumn(String baseColumnName, String outputName, boolean enableRowBasedMethods, boolean enableColumnBasedMethods, boolean enableBitmaps, boolean disableValueMatchers) {
        this.baseColumnName = baseColumnName;
        this.outputName = outputName;
        this.enableRowBasedMethods = enableRowBasedMethods;
        this.enableColumnBasedMethods = enableColumnBasedMethods;
        this.enableBitmaps = enableBitmaps;
        this.disableValueMatchers = disableValueMatchers;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        if (this.enableColumnBasedMethods) {
            ColumnHolder holder = columnSelector.getColumnHolder(this.baseColumnName);
            if (holder == null) {
                return DimensionSelector.constant(null);
            }
            StringDictionaryEncodedColumn stringCol = this.toStringDictionaryEncodedColumn(holder.getColumn());
            HistoricalDimensionSelector baseDimensionSelector = stringCol.makeDimensionSelector(offset, dimensionSpec.getExtractionFn());
            if (this.disableValueMatchers) {
                baseDimensionSelector = this.disableValueMatchers((DimensionSelector)baseDimensionSelector);
            }
            return dimensionSpec.decorate((DimensionSelector)baseDimensionSelector);
        }
        return null;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        if (this.enableRowBasedMethods) {
            DimensionSelector baseDimensionSelector = factory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(this.baseColumnName, this.baseColumnName, null));
            if (this.disableValueMatchers) {
                baseDimensionSelector = this.disableValueMatchers(baseDimensionSelector);
            }
            return dimensionSpec.decorate(baseDimensionSelector);
        }
        throw new UnsupportedOperationException("not supported");
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        if (this.enableColumnBasedMethods) {
            ColumnHolder holder = columnSelector.getColumnHolder(this.baseColumnName);
            if (holder == null) {
                return NilColumnValueSelector.instance();
            }
            StringDictionaryEncodedColumn stringCol = this.toStringDictionaryEncodedColumn(holder.getColumn());
            return stringCol.makeColumnValueSelector(offset);
        }
        return null;
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        if (this.enableRowBasedMethods) {
            return factory.makeColumnValueSelector(this.baseColumnName);
        }
        throw new UnsupportedOperationException("not supported");
    }

    public BitmapIndex getBitmapIndex(String columnName, ColumnSelector columnSelector) {
        if (this.enableBitmaps) {
            ColumnHolder holder = columnSelector.getColumnHolder(this.baseColumnName);
            if (holder == null) {
                return null;
            }
            return holder.getBitmapIndex();
        }
        throw new UnsupportedOperationException("not supported");
    }

    public ColumnCapabilities capabilities(String columnName) {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryEncoded(true);
        if (this.enableBitmaps) {
            capabilities.setHasBitmapIndexes(true);
        }
        return capabilities;
    }

    public List<String> requiredColumns() {
        return Collections.singletonList(this.baseColumnName);
    }

    public boolean usesDotNotation() {
        return false;
    }

    public byte[] getCacheKey() {
        return new byte[0];
    }

    private StringDictionaryEncodedColumn toStringDictionaryEncodedColumn(BaseColumn column) {
        if (!(column instanceof StringDictionaryEncodedColumn)) {
            throw new IAE("I can only work with StringDictionaryEncodedColumn", new Object[0]);
        }
        return (StringDictionaryEncodedColumn)column;
    }

    private DimensionSelector disableValueMatchers(final DimensionSelector base) {
        return new DimensionSelector(){

            public IndexedInts getRow() {
                return base.getRow();
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                throw new UnsupportedOperationException("not supported");
            }

            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                throw new UnsupportedOperationException("not supported");
            }

            public int getValueCardinality() {
                return base.getValueCardinality();
            }

            @Nullable
            public String lookupName(int id) {
                return base.lookupName(id);
            }

            public boolean nameLookupPossibleInAdvance() {
                return base.nameLookupPossibleInAdvance();
            }

            @Nullable
            public IdLookup idLookup() {
                return base.idLookup();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                base.inspectRuntimeShape(inspector);
            }

            @Nullable
            public Object getObject() {
                return base.getObject();
            }

            public Class<?> classOfObject() {
                return base.classOfObject();
            }
        };
    }
}

