/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.vector;

import java.util.Set;
import org.apache.hive.druid.org.apache.druid.collections.IntSetTestUtility;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.hive.druid.org.roaringbitmap.PeekableIntIterator;
import org.junit.Assert;
import org.junit.Test;

public class VectorSelectorUtilsTest {
    @Test
    public void testBitSetNullVector() {
        WrappedBitSetBitmap bitmap = new WrappedBitSetBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap);
        this.assertNullVector((ImmutableBitmap)bitmap);
    }

    @Test
    public void testConciseMutableNullVector() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap);
        this.assertNullVector((ImmutableBitmap)bitmap);
    }

    @Test
    public void testConciseImmutableNullVector() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap);
        WrappedImmutableConciseBitmap immutable = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)bitmap.getBitmap()));
        this.assertNullVector((ImmutableBitmap)immutable);
    }

    @Test
    public void testRoaringMutableNullVector() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap);
        this.assertNullVector((ImmutableBitmap)bitmap);
    }

    @Test
    public void testRoaringImmutableNullVector() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        VectorSelectorUtilsTest.populate((MutableBitmap)bitmap);
        this.assertNullVector(bitmap.toImmutableBitmap());
    }

    public static void populate(MutableBitmap bitmap) {
        for (int i : IntSetTestUtility.getSetBits()) {
            bitmap.add(i);
        }
    }

    private void assertNullVector(ImmutableBitmap bitmap) {
        PeekableIntIterator iterator = bitmap.peekableIterator();
        Set<Integer> nulls = IntSetTestUtility.getSetBits();
        int vectorSize = 32;
        boolean[] nullVector = new boolean[32];
        NoFilterVectorOffset someOffset = new NoFilterVectorOffset(32, 0, 32);
        VectorSelectorUtils.populateNullVector((boolean[])nullVector, (ReadableVectorOffset)someOffset, (PeekableIntIterator)iterator);
        for (int i = 0; i < 32; ++i) {
            Assert.assertEquals((Object)nulls.contains(i), (Object)nullVector[i]);
        }
        iterator = bitmap.peekableIterator();
        int smallerVectorSize = 8;
        boolean[] smallVector = null;
        for (int offset = 0; offset < 32; offset += 8) {
            NoFilterVectorOffset smallOffset = new NoFilterVectorOffset(8, offset, offset + 8);
            smallVector = VectorSelectorUtils.populateNullVector(smallVector, (ReadableVectorOffset)smallOffset, (PeekableIntIterator)iterator);
            for (int i = 0; i < 8; ++i) {
                if (smallVector == null) {
                    Assert.assertFalse((boolean)nulls.contains(offset + i));
                    continue;
                }
                Assert.assertEquals((Object)nulls.contains(offset + i), (Object)smallVector[i]);
            }
            smallVector = null;
        }
        iterator = bitmap.peekableIterator();
        BitmapVectorOffset allTheNulls = new BitmapVectorOffset(8, bitmap, 0, 22);
        smallVector = VectorSelectorUtils.populateNullVector((boolean[])smallVector, (ReadableVectorOffset)allTheNulls, (PeekableIntIterator)iterator);
        for (int i = 0; i < nulls.size(); ++i) {
            Assert.assertTrue((boolean)smallVector[i]);
        }
    }
}

