/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.serde;

import java.nio.ByteOrder;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.hive.druid.org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.junit.Assert;
import org.junit.Test;

public class DictionaryEncodedColumnPartSerdeTest {
    @Test
    public void testSerde() throws Exception {
        String json = "{\n \"type\": \"stringDictionary\",\n \"byteOrder\": \"BIG_ENDIAN\"\n}\n";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        DictionaryEncodedColumnPartSerde serde = (DictionaryEncodedColumnPartSerde)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ColumnPartSerde.class)), ColumnPartSerde.class);
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serde.getByteOrder());
        Assert.assertTrue((boolean)(serde.getBitmapSerdeFactory() instanceof ConciseBitmapSerdeFactory));
        json = "{\n\"type\": \"stringDictionary\",\n\"byteOrder\": \"LITTLE_ENDIAN\",\n\"bitmapSerdeFactory\": { \"type\": \"roaring\" }\n}";
        serde = (DictionaryEncodedColumnPartSerde)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ColumnPartSerde.class)), ColumnPartSerde.class);
        Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)serde.getByteOrder());
        Assert.assertTrue((boolean)(serde.getBitmapSerdeFactory() instanceof RoaringBitmapSerdeFactory));
    }
}

