/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.plumber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.TuningConfigs;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireHydrant;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.Sink;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class SinkTest {
    @Test
    public void testSwap() throws Exception {
        DataSchema schema = new DataSchema("test", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[]{new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null);
        Interval interval = Intervals.of((String)"2013-01-01/2013-01-02");
        String version = DateTimes.nowUtc().toString();
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(Integer.valueOf(100), null, new Period((Object)"P1Y"), null, null, null, null, null, null, null, null, null, 0, 0, null, null, null, null, null);
        Sink sink = new Sink(interval, schema, tuningConfig.getShardSpec(), version, tuningConfig.getMaxRowsInMemory(), TuningConfigs.getMaxBytesInMemoryOrDefault((long)tuningConfig.getMaxBytesInMemory()), tuningConfig.isReportParseExceptions(), tuningConfig.getDedupColumn());
        sink.add(new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>();
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)"2013-01-01").getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)"2013-01-01");
            }

            public List<String> getDimension(String dimension) {
                return new ArrayList<String>();
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        }, false);
        FireHydrant currHydrant = sink.getCurrHydrant();
        Assert.assertEquals((Object)Intervals.of((String)"2013-01-01/PT1M"), (Object)currHydrant.getIndex().getInterval());
        FireHydrant swapHydrant = sink.swap();
        sink.add(new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>();
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)"2013-01-01").getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)"2013-01-01");
            }

            public List<String> getDimension(String dimension) {
                return new ArrayList<String>();
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        }, false);
        Assert.assertEquals((Object)currHydrant, (Object)swapHydrant);
        Assert.assertNotSame((Object)currHydrant, (Object)sink.getCurrHydrant());
        Assert.assertEquals((Object)Intervals.of((String)"2013-01-01/PT1M"), (Object)sink.getCurrHydrant().getIndex().getInterval());
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)sink.iterator()));
    }

    @Test
    public void testDedup() throws Exception {
        DataSchema schema = new DataSchema("test", new TimestampSpec(null, null, null), DimensionsSpec.EMPTY, new AggregatorFactory[]{new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null);
        Interval interval = Intervals.of((String)"2013-01-01/2013-01-02");
        String version = DateTimes.nowUtc().toString();
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(Integer.valueOf(100), null, new Period((Object)"P1Y"), null, null, null, null, null, null, null, null, null, 0, 0, null, null, null, null, "dedupColumn");
        Sink sink = new Sink(interval, schema, tuningConfig.getShardSpec(), version, tuningConfig.getMaxRowsInMemory(), TuningConfigs.getMaxBytesInMemoryOrDefault((long)tuningConfig.getMaxBytesInMemory()), tuningConfig.isReportParseExceptions(), tuningConfig.getDedupColumn());
        int rows = sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"field", (Object)"dedupColumn"), (Map)ImmutableMap.of((Object)"field1", (Object)"value1", (Object)"dedupColumn", (Object)"v1")), false).getRowCount();
        Assert.assertTrue((rows > 0 ? 1 : 0) != 0);
        rows = sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"field", (Object)"dedupColumn"), (Map)ImmutableMap.of((Object)"field1", (Object)"value2")), false).getRowCount();
        Assert.assertTrue((rows > 0 ? 1 : 0) != 0);
        rows = sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"field", (Object)"dedupColumn"), (Map)ImmutableMap.of((Object)"field1", (Object)"value3")), false).getRowCount();
        Assert.assertTrue((rows > 0 ? 1 : 0) != 0);
        rows = sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"field", (Object)"dedupColumn"), (Map)ImmutableMap.of((Object)"field1", (Object)"value4", (Object)"dedupColumn", (Object)"v2")), false).getRowCount();
        Assert.assertTrue((rows > 0 ? 1 : 0) != 0);
        rows = sink.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01"), (List)ImmutableList.of((Object)"field", (Object)"dedupColumn"), (Map)ImmutableMap.of((Object)"field1", (Object)"value5", (Object)"dedupColumn", (Object)"v1")), false).getRowCount();
        Assert.assertTrue((rows == -2 ? 1 : 0) != 0);
    }
}

