/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.hive.druid.org.apache.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.SqlFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.segment.transform.TransformSpec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;

public class SqlFirehoseFactoryTest {
    private static final List<File> FIREHOSE_TMP_DIRS = new ArrayList<File>();
    private static File TEST_DIR;
    private final String TABLE_NAME_1 = "FOOS_TABLE_1";
    private final String TABLE_NAME_2 = "FOOS_TABLE_2";
    private final List<String> SQLLIST1 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1");
    private final List<String> SQLLIST2 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1", (Object)"SELECT timestamp,a,b FROM FOOS_TABLE_2");
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeSmileMapper();
    private final InputRowParser parser = TransformSpec.NONE.decorate((InputRowParser)new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a", "b")), new ArrayList(), new ArrayList()))));
    private TestDerbyConnector derbyConnector;
    private TestDerbyFirehoseConnector derbyFirehoseConnector;

    @BeforeClass
    public static void setup() throws IOException {
        TEST_DIR = File.createTempFile(SqlFirehoseFactoryTest.class.getSimpleName(), "testDir");
        FileUtils.forceDelete((File)TEST_DIR);
        FileUtils.forceMkdir((File)TEST_DIR);
    }

    @AfterClass
    public static void teardown() throws IOException {
        FileUtils.forceDelete((File)TEST_DIR);
        for (File dir : FIREHOSE_TMP_DIRS) {
            FileUtils.forceDelete((File)dir);
        }
    }

    private void assertResult(List<Row> rows, List<String> sqls) {
        Assert.assertEquals((long)(10 * sqls.size()), (long)rows.size());
        rows.sort(Comparator.comparing(Row::getTimestamp).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("a").get(0))).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("b").get(0))));
        int rowCount = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < sqls.size(); ++j) {
                Row row = rows.get(rowCount);
                String timestampSt = StringUtils.format((String)"2011-01-12T00:0%s:00.000Z", (Object[])new Object[]{i});
                Assert.assertEquals((Object)timestampSt, (Object)row.getTimestamp().toString());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("a").get(0)).intValue());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("b").get(0)).intValue());
                ++rowCount;
            }
        }
    }

    private void assertNumRemainingCacheFiles(File firehoseTmpDir, int expectedNumFiles) {
        String[] files = firehoseTmpDir.list();
        Assert.assertNotNull((Object)files);
        Assert.assertEquals((long)expectedNumFiles, (long)files.length);
    }

    private File createFirehoseTmpDir(String dirSuffix) throws IOException {
        File firehoseTempDir = File.createTempFile(SqlFirehoseFactoryTest.class.getSimpleName(), dirSuffix);
        FileUtils.forceDelete((File)firehoseTempDir);
        FileUtils.forceMkdir((File)firehoseTempDir);
        FIREHOSE_TMP_DIRS.add(firehoseTempDir);
        return firehoseTempDir;
    }

    private void dropTable(String tableName) {
        this.derbyConnector.getDBI().withHandle(handle -> {
            handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
            return null;
        });
    }

    private void createAndUpdateTable(String tableName) {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.derbyFirehoseConnector = new TestDerbyFirehoseConnector(new MetadataStorageConnectorConfig(), this.derbyConnector.getDBI());
        this.derbyConnector.createTable(tableName, (Iterable)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  timestamp varchar(255) NOT NULL,\n  a VARCHAR(255) NOT NULL,\n  b VARCHAR(255) NOT NULL\n)", (Object[])new Object[]{tableName})));
        this.derbyConnector.getDBI().withHandle(handle -> {
            Batch batch = handle.createBatch();
            for (int i = 0; i < 10; ++i) {
                String timestampSt = StringUtils.format((String)"2011-01-12T00:0%s:00.000Z", (Object[])new Object[]{i});
                batch.add(StringUtils.format((String)"INSERT INTO %1$s (timestamp, a, b) VALUES ('%2$s', '%3$s', '%4$s')", (Object[])new Object[]{tableName, timestampSt, i, i}));
            }
            batch.execute();
            return null;
        });
    }

    @Test
    public void testWithoutCacheAndFetch() throws Exception {
        this.createAndUpdateTable("FOOS_TABLE_1");
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST1, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), true, (SQLFirehoseDatabaseConnector)this.derbyFirehoseConnector, this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithoutCacheAndFetch");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST1);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 0);
        this.dropTable("FOOS_TABLE_1");
    }

    @Test
    public void testWithoutCache() throws IOException {
        this.createAndUpdateTable("FOOS_TABLE_1");
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST1, Long.valueOf(0L), null, null, null, true, (SQLFirehoseDatabaseConnector)this.derbyFirehoseConnector, this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithoutCache");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST1);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 0);
        this.dropTable("FOOS_TABLE_1");
    }

    @Test
    public void testWithCacheAndFetch() throws IOException {
        this.createAndUpdateTable("FOOS_TABLE_1");
        this.createAndUpdateTable("FOOS_TABLE_2");
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST2, null, null, Long.valueOf(0L), null, true, (SQLFirehoseDatabaseConnector)this.derbyFirehoseConnector, this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithCacheAndFetch");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST2);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 2);
        this.dropTable("FOOS_TABLE_1");
        this.dropTable("FOOS_TABLE_2");
    }

    private static class TestDerbyFirehoseConnector
    extends SQLFirehoseDatabaseConnector {
        private final DBI dbi;

        private TestDerbyFirehoseConnector(MetadataStorageConnectorConfig metadataStorageConnectorConfig, DBI dbi) {
            BasicDataSource datasource = this.getDatasource(metadataStorageConnectorConfig);
            datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            datasource.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
            this.dbi = dbi;
        }

        public DBI getDBI() {
            return this.dbi;
        }
    }
}

