/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorTester;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.org.apache.druid.timeline.partition.PartitionChunk;

public class TestUsedSegmentChecker
implements UsedSegmentChecker {
    private final AppenderatorTester appenderatorTester;

    public TestUsedSegmentChecker(AppenderatorTester appenderatorTester) {
        this.appenderatorTester = appenderatorTester;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdWithShardSpec> identifiers) {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        VersionedIntervalTimeline.addSegments((VersionedIntervalTimeline)timeline, this.appenderatorTester.getPushedSegments().iterator());
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        for (SegmentIdWithShardSpec identifier : identifiers) {
            for (TimelineObjectHolder holder : timeline.lookup(identifier.getInterval())) {
                for (PartitionChunk chunk : holder.getObject()) {
                    if (!identifiers.contains(SegmentIdWithShardSpec.fromDataSegment((DataSegment)((DataSegment)chunk.getObject())))) continue;
                    retVal.add((DataSegment)chunk.getObject());
                }
            }
        }
        return retVal;
    }
}

