/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentIdWithShardSpecTest {
    private static final String DATA_SOURCE = "foo";
    private static final Interval INTERVAL = Intervals.of((String)"2000/PT1H");
    private static final String VERSION = "v1";
    private static final NumberedShardSpec SHARD_SPEC_0 = new NumberedShardSpec(0, 2);
    private static final NumberedShardSpec SHARD_SPEC_1 = new NumberedShardSpec(1, 2);
    private static final SegmentIdWithShardSpec ID_0 = new SegmentIdWithShardSpec("foo", INTERVAL, "v1", (ShardSpec)SHARD_SPEC_0);
    private static final SegmentIdWithShardSpec ID_1 = new SegmentIdWithShardSpec("foo", INTERVAL, "v1", (ShardSpec)SHARD_SPEC_1);

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.registerSubtypes(new Class[]{NumberedShardSpec.class});
        SegmentIdWithShardSpec id2 = (SegmentIdWithShardSpec)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)ID_1), SegmentIdWithShardSpec.class);
        Assert.assertEquals((Object)ID_1, (Object)id2);
        Assert.assertEquals((Object)DATA_SOURCE, (Object)id2.getDataSource());
        Assert.assertEquals((Object)INTERVAL, (Object)id2.getInterval());
        Assert.assertEquals((Object)VERSION, (Object)id2.getVersion());
        Assert.assertEquals((long)SHARD_SPEC_1.getPartitionNum(), (long)id2.getShardSpec().getPartitionNum());
        Assert.assertEquals((long)SHARD_SPEC_1.getPartitions(), (long)((NumberedShardSpec)id2.getShardSpec()).getPartitions());
    }

    @Test
    public void testAsString() {
        Assert.assertEquals((Object)"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_v1", (Object)ID_0.toString());
        Assert.assertEquals((Object)"foo_2000-01-01T00:00:00.000Z_2000-01-01T01:00:00.000Z_v1_1", (Object)ID_1.toString());
    }
}

