/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.AppenderatorTester;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.BaseAppenderatorDriver;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentWithState;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.StreamAppenderatorDriverTest;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.TestUsedSegmentChecker;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.hive.druid.org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BatchAppenderatorDriverTest
extends EasyMockSupport {
    private static final String DATA_SOURCE = "foo";
    private static final String VERSION = "abc123";
    private static final int MAX_ROWS_IN_MEMORY = 100;
    private static final long TIMEOUT = 1000L;
    private static final List<InputRow> ROWS = Arrays.asList(new MapBasedInputRow(DateTimes.of((String)"2000"), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"foo", (Object)"met1", (Object)"1")), new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"foo", (Object)"met1", (Object)2.0)), new MapBasedInputRow(DateTimes.of((String)"2000T01"), (List)ImmutableList.of((Object)"dim2"), (Map)ImmutableMap.of((Object)"dim2", (Object)"bar", (Object)"met1", (Object)2.0)));
    private SegmentAllocator allocator;
    private AppenderatorTester appenderatorTester;
    private BatchAppenderatorDriver driver;
    private DataSegmentKiller dataSegmentKiller;

    @Before
    public void setup() {
        this.appenderatorTester = new AppenderatorTester(100);
        this.allocator = new StreamAppenderatorDriverTest.TestSegmentAllocator(DATA_SOURCE, Granularities.HOUR);
        this.dataSegmentKiller = (DataSegmentKiller)this.createStrictMock(DataSegmentKiller.class);
        this.driver = new BatchAppenderatorDriver(this.appenderatorTester.getAppenderator(), this.allocator, (UsedSegmentChecker)new TestUsedSegmentChecker(this.appenderatorTester), this.dataSegmentKiller);
        EasyMock.replay((Object[])new Object[]{this.dataSegmentKiller});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.dataSegmentKiller});
        this.driver.clear();
        this.driver.close();
    }

    @Test
    public void testSimple() throws Exception {
        Assert.assertNull((Object)this.driver.startJob(null));
        for (InputRow row : ROWS) {
            Assert.assertTrue((boolean)this.driver.add(row, "dummy").isOk());
        }
        this.checkSegmentStates(2, SegmentWithState.SegmentState.APPENDING);
        this.driver.pushAllAndClear(1000L);
        this.checkSegmentStates(2, SegmentWithState.SegmentState.PUSHED_AND_DROPPED);
        SegmentsAndMetadata published = (SegmentsAndMetadata)this.driver.publishAll(null, BatchAppenderatorDriverTest.makeOkPublisher()).get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new SegmentIdWithShardSpec(DATA_SOURCE, Intervals.of((String)"2000/PT1H"), VERSION, (ShardSpec)new NumberedShardSpec(0, 0)), (Object)new SegmentIdWithShardSpec(DATA_SOURCE, Intervals.of((String)"2000T01/PT1H"), VERSION, (ShardSpec)new NumberedShardSpec(0, 0))), published.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet()));
        Assert.assertNull((Object)published.getCommitMetadata());
    }

    @Test
    public void testIncrementalPush() throws Exception {
        Assert.assertNull((Object)this.driver.startJob(null));
        int i = 0;
        for (InputRow row : ROWS) {
            Assert.assertTrue((boolean)this.driver.add(row, "dummy").isOk());
            this.checkSegmentStates(1, SegmentWithState.SegmentState.APPENDING);
            this.checkSegmentStates(i, SegmentWithState.SegmentState.PUSHED_AND_DROPPED);
            this.driver.pushAllAndClear(1000L);
            this.checkSegmentStates(0, SegmentWithState.SegmentState.APPENDING);
            this.checkSegmentStates(++i, SegmentWithState.SegmentState.PUSHED_AND_DROPPED);
        }
        SegmentsAndMetadata published = (SegmentsAndMetadata)this.driver.publishAll(null, BatchAppenderatorDriverTest.makeOkPublisher()).get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new SegmentIdWithShardSpec(DATA_SOURCE, Intervals.of((String)"2000/PT1H"), VERSION, (ShardSpec)new NumberedShardSpec(0, 0)), (Object)new SegmentIdWithShardSpec(DATA_SOURCE, Intervals.of((String)"2000T01/PT1H"), VERSION, (ShardSpec)new NumberedShardSpec(0, 0)), (Object)new SegmentIdWithShardSpec(DATA_SOURCE, Intervals.of((String)"2000T01/PT1H"), VERSION, (ShardSpec)new NumberedShardSpec(1, 0))), published.getSegments().stream().map(SegmentIdWithShardSpec::fromDataSegment).collect(Collectors.toSet()));
        Assert.assertNull((Object)published.getCommitMetadata());
    }

    @Test
    public void testRestart() {
        Assert.assertNull((Object)this.driver.startJob(null));
        this.driver.close();
        this.appenderatorTester.getAppenderator().close();
        Assert.assertNull((Object)this.driver.startJob(null));
    }

    private void checkSegmentStates(int expectedNumSegmentsInState, SegmentWithState.SegmentState expectedState) {
        BaseAppenderatorDriver.SegmentsForSequence segmentsForSequence = (BaseAppenderatorDriver.SegmentsForSequence)this.driver.getSegments().get("dummy");
        Assert.assertNotNull((Object)segmentsForSequence);
        List segmentWithStates = segmentsForSequence.allSegmentStateStream().filter(segmentWithState -> segmentWithState.getState() == expectedState).collect(Collectors.toList());
        Assert.assertEquals((long)expectedNumSegmentsInState, (long)segmentWithStates.size());
    }

    static TransactionalSegmentPublisher makeOkPublisher() {
        return (segmentsToBeOverwritten, segmentsToPublish, commitMetadata) -> SegmentPublishResult.ok((Set)ImmutableSet.of());
    }
}

