/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.realtime;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.hive.druid.org.apache.druid.client.cache.MapCache;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeIOConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.realtime.FireDepartment;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.PlumberSchool;
import org.apache.hive.druid.org.apache.druid.segment.realtime.plumber.RealtimePlumberSchool;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Test;

public class FireDepartmentTest {
    public static final CacheConfig NO_CACHE_CONFIG = new CacheConfig(){

        public boolean isPopulateCache() {
            return false;
        }

        public boolean isUseCache() {
            return false;
        }
    };

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)jsonMapper));
        FireDepartment schema = new FireDepartment(new DataSchema("foo", (Map)jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("dim1", "dim2")), null, null), null, null), null), Map.class), new AggregatorFactory[]{new CountAggregatorFactory("count")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.MINUTE, null), null, (ObjectMapper)jsonMapper), new RealtimeIOConfig(null, (PlumberSchool)new RealtimePlumberSchool(null, null, null, null, null, null, null, TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()), TestHelper.getTestIndexIO(), MapCache.create((long)0L), NO_CACHE_CONFIG, new CachePopulatorStats(), TestHelper.makeJsonMapper())), RealtimeTuningConfig.makeDefaultTuningConfig((File)new File("/tmp/nonexistent")));
        String json = jsonMapper.writeValueAsString((Object)schema);
        FireDepartment newSchema = (FireDepartment)jsonMapper.readValue(json, FireDepartment.class);
        Assert.assertEquals((Object)schema.getDataSchema().getDataSource(), (Object)newSchema.getDataSchema().getDataSource());
        Assert.assertEquals((Object)"/tmp/nonexistent", (Object)schema.getTuningConfig().getBasePersistDirectory().toString());
    }
}

