/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class StorageLocationTest {
    @Test
    public void testStorageLocationFreePercent() {
        StorageLocation locationPlain = this.fakeLocation(100000L, 5000L, 10000L, null);
        Assert.assertTrue((boolean)locationPlain.canHandle(this.newSegmentId("2012/2013").toString(), 9000L));
        Assert.assertFalse((boolean)locationPlain.canHandle(this.newSegmentId("2012/2013").toString(), 11000L));
        StorageLocation locationFree = this.fakeLocation(100000L, 25000L, 10000L, 10.0);
        Assert.assertTrue((boolean)locationFree.canHandle(this.newSegmentId("2012/2013").toString(), 9000L));
        Assert.assertFalse((boolean)locationFree.canHandle(this.newSegmentId("2012/2013").toString(), 11000L));
        StorageLocation locationFull = this.fakeLocation(100000L, 15000L, 10000L, 10.0);
        Assert.assertTrue((boolean)locationFull.canHandle(this.newSegmentId("2012/2013").toString(), 4000L));
        Assert.assertFalse((boolean)locationFull.canHandle(this.newSegmentId("2012/2013").toString(), 6000L));
    }

    private StorageLocation fakeLocation(long total, long free, long max, Double percent) {
        File file = (File)EasyMock.mock(File.class);
        EasyMock.expect((Object)file.getTotalSpace()).andReturn((Object)total).anyTimes();
        EasyMock.expect((Object)file.getFreeSpace()).andReturn((Object)free).anyTimes();
        EasyMock.replay((Object[])new Object[]{file});
        return new StorageLocation(file, max, percent);
    }

    @Test
    public void testStorageLocation() {
        long expectedAvail = 1000L;
        StorageLocation loc = new StorageLocation(new File("/tmp"), expectedAvail, null);
        this.verifyLoc(expectedAvail, loc);
        DataSegment secondSegment = this.makeSegment("2012-01-02/2012-01-03", 23L);
        loc.reserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail -= 10L, loc);
        loc.reserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.reserve("test2", secondSegment);
        this.verifyLoc(expectedAvail -= 23L, loc);
        loc.removeSegmentDir(new File("/tmp/test1"), this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail += 10L, loc);
        loc.removeSegmentDir(new File("/tmp/test1"), this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.removeSegmentDir(new File("/tmp/test2"), secondSegment);
        this.verifyLoc(expectedAvail += 23L, loc);
    }

    private void verifyLoc(long maxSize, StorageLocation loc) {
        Assert.assertEquals((long)maxSize, (long)loc.availableSizeBytes());
        int i = 0;
        while ((long)i <= maxSize) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)loc.canHandle(this.newSegmentId("2013/2014").toString(), (long)i));
            ++i;
        }
    }

    private DataSegment makeSegment(String intervalString, long size) {
        return new DataSegment("test", Intervals.of((String)intervalString), "1", (Map)ImmutableMap.of(), Collections.singletonList("d"), Collections.singletonList("m"), null, null, size);
    }

    private SegmentId newSegmentId(String intervalString) {
        return SegmentId.of((String)"test", (Interval)Intervals.of((String)intervalString), (String)"1", (int)0);
    }
}

