/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.druid.org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.RandomStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.RoundRobinStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StorageLocationSelectorStrategyTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testLeastBytesUsedLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        StorageLocation storageLocation1 = new StorageLocation(localStorageFolder1, 10000000000L, null);
        storageLocations.add(storageLocation1);
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        LeastBytesUsedStorageLocationSelectorStrategy leastBytesUsedStrategy = new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations);
        storageLocation1.reserve("tmp_loc1", "__seg1", 1024L);
        Iterator locations = leastBytesUsedStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc1.getPath());
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc2.getPath());
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc3.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategySingleLocation() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc2.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        locations = roundRobinStrategy.getLocations();
        loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
    }

    @Test
    public void testRoundRobinLocationSelectorStrategyMultipleCallsToGetLocations() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 10000000000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 10000000000L, null));
        RoundRobinStorageLocationSelectorStrategy roundRobinStrategy = new RoundRobinStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = roundRobinStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc2 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_2", (Object)localStorageFolder2, (Object)loc2.getPath());
        locations = roundRobinStrategy.getLocations();
        StorageLocation loc3 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_3", (Object)localStorageFolder3, (Object)loc3.getPath());
        loc1 = (StorageLocation)locations.next();
        Assert.assertEquals((String)"The next element of the iterator should point to path local_storage_folder_1", (Object)localStorageFolder1, (Object)loc1.getPath());
    }

    @Test
    public void testRandomLocationSelectorStrategy() throws Exception {
        ArrayList<StorageLocation> storageLocations = new ArrayList<StorageLocation>();
        File localStorageFolder1 = this.tmpFolder.newFolder("local_storage_folder_1");
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder_2");
        File localStorageFolder3 = this.tmpFolder.newFolder("local_storage_folder_3");
        storageLocations.add(new StorageLocation(localStorageFolder1, 3000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder2, 2000L, null));
        storageLocations.add(new StorageLocation(localStorageFolder3, 1000L, null));
        RandomStorageLocationSelectorStrategy leastBytesUsedStrategy = new RandomStorageLocationSelectorStrategy(storageLocations);
        Iterator locations = leastBytesUsedStrategy.getLocations();
        StorageLocation loc1 = (StorageLocation)locations.next();
        StorageLocation loc2 = (StorageLocation)locations.next();
        StorageLocation loc3 = (StorageLocation)locations.next();
        Object[] result = new File[]{loc1.getPath(), loc2.getPath(), loc3.getPath()};
        Arrays.sort(result);
        Assert.assertArrayEquals((Object[])new File[]{localStorageFolder1, localStorageFolder2, localStorageFolder3}, (Object[])result);
    }
}

