/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.jackson.SegmentizerModule;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentizerFactory;
import org.junit.Assert;
import org.junit.Test;

public class SegmentizerFactoryTest {
    @Test
    public void testFactory() throws IOException {
        File factoryFile = Files.createTempFile("", "factory.json", new FileAttribute[0]).toFile();
        FileOutputStream fos = new FileOutputStream(factoryFile);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerModule((Module)new SegmentizerModule());
        IndexIO indexIO = new IndexIO((ObjectMapper)mapper, new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 777;
            }
        });
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(IndexIO.class, (Object)indexIO));
        mapper.writeValue((OutputStream)fos, (Object)new MMappedQueryableSegmentizerFactory(indexIO));
        fos.close();
        SegmentizerFactory factory = (SegmentizerFactory)mapper.readValue(factoryFile, SegmentizerFactory.class);
        Assert.assertTrue((boolean)(factory instanceof MMappedQueryableSegmentizerFactory));
    }
}

