/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.RandomStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.RoundRobinStorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderLocalCacheManager;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocation;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentLoaderLocalCacheManagerTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private File localSegmentCacheFolder;
    private SegmentLoaderLocalCacheManager manager;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public SegmentLoaderLocalCacheManagerTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")});
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()));
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @Before
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.localSegmentCacheFolder = this.tmpFolder.newFolder("segment_cache_folder");
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheFolder, Long.valueOf(10000000000L), null);
        locations.add(locationConfig);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
    }

    @Test
    public void testIfSegmentIsLoaded() {
        DataSegment cachedSegment = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D");
        File cachedSegmentFile = new File(this.localSegmentCacheFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        cachedSegmentFile.mkdirs();
        Assert.assertTrue((String)"Expect cache hit", (boolean)this.manager.isSegmentLoaded(cachedSegment));
        DataSegment uncachedSegment = this.dataSegmentWithInterval("2014-10-21T00:00:00Z/P1D");
        Assert.assertFalse((String)"Expect cache miss", (boolean)this.manager.isSegmentLoaded(uncachedSegment));
    }

    @Test
    public void testGetAndCleanSegmentFiles() throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(localStorageFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(localStorageFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtFirstLocation() throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, Long.valueOf(10000000000L), null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, Long.valueOf(1000000000L), null);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtSecondLocation() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, Long.valueOf(1000000000L), null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, Long.valueOf(10000000L), null);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
    }

    @Test
    public void testRetryAllFail() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, Long.valueOf(1000000000L), null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(false);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, Long.valueOf(10000000L), null);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        try {
            this.manager.getSegmentFiles(segmentToDownload);
            Assert.fail();
        }
        catch (SegmentLoadingException segmentLoadingException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        this.manager.cleanup(segmentToDownload);
    }

    @Test
    public void testEmptyToFullOrder() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(true);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, Long.valueOf(10L), null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(true);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, Long.valueOf(10L), null);
        locations.add(locationConfig2);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile = new File(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        DataSegment segmentToDownload2 = this.dataSegmentWithInterval("2014-11-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        File localSegmentFile2 = new File(segmentSrcFolder, "test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        localSegmentFile2.mkdirs();
        File indexZip2 = new File(localSegmentFile2, "index.zip");
        indexZip2.createNewFile();
        File segmentFile2 = this.manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        this.manager.cleanup(segmentToDownload2);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
    }

    private DataSegment dataSegmentWithInterval(String intervalStr) {
        return this.dataSegmentWithInterval(intervalStr, 10L);
    }

    private DataSegment dataSegmentWithInterval(String intervalStr, long size) {
        return DataSegment.builder().dataSource("test_segment_loader").interval(Intervals.of((String)intervalStr)).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("2015-05-27T03:38:35.683Z").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)NoneShardSpec.instance()).binaryVersion(Integer.valueOf(9)).size(size).build();
    }

    @Test
    public void testSegmentDistributionUsingRoundRobinStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locationConfigs = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10000000000L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 1000000000L, true);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 1000000000L, true);
        locationConfigs.add(locationConfig);
        locationConfigs.add(locationConfig2);
        locationConfigs.add(locationConfig3);
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        for (StorageLocationConfig locConfig : locationConfigs) {
            locations.add(new StorageLocation(locConfig.getPath(), locConfig.getMaxSize(), locConfig.getFreeSpacePercent()));
        }
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locationConfigs).withStorageLocationSelectorStrategy((StorageLocationSelectorStrategy)new RoundRobinStorageLocationSelectorStrategy(locations)), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload1 = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload1));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload1);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload1));
        this.manager.cleanup(segmentToDownload1);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload1));
        DataSegment segmentToDownload2 = this.dataSegmentWithInterval("2014-11-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        File segmentFile2 = this.manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        this.manager.cleanup(segmentToDownload2);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        DataSegment segmentToDownload3 = this.dataSegmentWithInterval("2014-12-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        File segmentFile3 = this.manager.getSegmentFiles(segmentToDownload3);
        Assert.assertTrue((boolean)segmentFile3.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload3));
        this.manager.cleanup(segmentToDownload3);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload3));
        DataSegment segmentToDownload4 = this.dataSegmentWithInterval("2014-08-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-08-20T00:00:00.000Z_2014-08-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-08-20T00:00:00.000Z_2014-08-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload4));
        File segmentFile1 = this.manager.getSegmentFiles(segmentToDownload4);
        Assert.assertTrue((boolean)segmentFile1.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload4));
        this.manager.cleanup(segmentToDownload4);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload4));
    }

    private void createLocalSegmentFile(File segmentSrcFolder, String localSegmentPath) throws Exception {
        File localSegmentFile = new File(segmentSrcFolder, localSegmentPath);
        localSegmentFile.mkdirs();
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
    }

    private StorageLocationConfig createStorageLocationConfig(String localPath, long maxSize, boolean writable) throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder(localPath);
        localStorageFolder.setWritable(writable);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, Long.valueOf(maxSize), Double.valueOf(1.0));
        return locationConfig;
    }

    @Test
    public void testSegmentDistributionUsingLeastBytesUsedStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10000000000L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 1000000000L, true);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 1000000000L, true);
        locations.add(locationConfig);
        locations.add(locationConfig2);
        locations.add(locationConfig3);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D", 10L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        DataSegment segmentToDownload2 = this.dataSegmentWithInterval("2014-11-20T00:00:00Z/P1D", 5L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        File segmentFile2 = this.manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        DataSegment segmentToDownload3 = this.dataSegmentWithInterval("2014-12-20T00:00:00Z/P1D", 20L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        File segmentFile3 = this.manager.getSegmentFiles(segmentToDownload3);
        Assert.assertTrue((boolean)segmentFile3.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload3));
        DataSegment segmentToDownload4 = this.dataSegmentWithInterval("2014-08-20T00:00:00Z/P1D").withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-08-20T00:00:00.000Z_2014-08-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-08-20T00:00:00.000Z_2014-08-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload4));
        File segmentFile1 = this.manager.getSegmentFiles(segmentToDownload4);
        Assert.assertTrue((boolean)segmentFile1.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload4));
    }

    @Test
    public void testSegmentDistributionUsingRandomStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locationConfigs = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 100L, false);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 9L, true);
        locationConfigs.add(locationConfig);
        locationConfigs.add(locationConfig2);
        locationConfigs.add(locationConfig3);
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        for (StorageLocationConfig locConfig : locationConfigs) {
            locations.add(new StorageLocation(locConfig.getPath(), locConfig.getMaxSize(), null));
        }
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locationConfigs).withStorageLocationSelectorStrategy((StorageLocationSelectorStrategy)new RandomStorageLocationSelectorStrategy(locations)), this.jsonMapper);
        File segmentSrcFolder = this.tmpFolder.newFolder("segmentSrcFolder");
        DataSegment segmentToDownload = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D", 10L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        File segmentFile = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload));
        DataSegment segmentToDownload2 = this.dataSegmentWithInterval("2014-11-20T00:00:00Z/P1D", 9L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-11-20T00:00:00.000Z_2014-11-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        File segmentFile2 = this.manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload2));
        DataSegment segmentToDownload3 = this.dataSegmentWithInterval("2014-12-20T00:00:00Z/P1D", 20L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0/index.zip")));
        this.createLocalSegmentFile(segmentSrcFolder, "test_segment_loader/2014-12-20T00:00:00.000Z_2014-12-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        try {
            this.manager.getSegmentFiles(segmentToDownload3);
            Assert.fail();
        }
        catch (SegmentLoadingException segmentLoadingException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentLoaded(segmentToDownload3));
    }
}

