/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoaderLocalCacheManager;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.CoreMatchers;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class SegmentLoaderLocalCacheManagerConcurrencyTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final String dataSource = "test_ds";
    private final String segmentVersion;
    private File localSegmentCacheFolder;
    private SegmentLoaderLocalCacheManager manager;
    private ExecutorService executorService;

    public SegmentLoaderLocalCacheManagerConcurrencyTest() {
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")});
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()));
        this.segmentVersion = DateTimes.nowUtc().toString();
    }

    @Before
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.localSegmentCacheFolder = this.tmpFolder.newFolder("segment_cache_folder");
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheFolder, Long.valueOf(2000L), null);
        locations.add(locationConfig);
        this.manager = new SegmentLoaderLocalCacheManager(TestHelper.getTestIndexIO(), new SegmentLoaderConfig().withLocations(locations), this.jsonMapper);
        this.executorService = Execs.multiThreaded((int)4, (String)"segment-loader-local-cache-manager-concurrency-test-%d");
    }

    @After
    public void tearDown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testGetSegment() throws IOException, ExecutionException, InterruptedException {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        ArrayList<DataSegment> segmentsToLoad = new ArrayList<DataSegment>(4);
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        for (int partitionId = 0; partitionId < 4; ++partitionId) {
            String segmentPath = Paths.get(localStorageFolder.getCanonicalPath(), "test_ds", StringUtils.format((String)"%s_%s", (Object[])new Object[]{interval.getStart().toString(), interval.getEnd().toString()}), this.segmentVersion, String.valueOf(partitionId)).toString();
            File localSegmentFile = new File(localStorageFolder, segmentPath);
            localSegmentFile.mkdirs();
            File indexZip = new File(localSegmentFile, "index.zip");
            indexZip.createNewFile();
            DataSegment segment2 = this.newSegment(interval, partitionId).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)localSegmentFile.getAbsolutePath()));
            segmentsToLoad.add(segment2);
        }
        List futures = segmentsToLoad.stream().map(segment -> this.executorService.submit(() -> this.manager.getSegmentFiles(segment))).collect(Collectors.toList());
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(SegmentLoadingException.class));
        this.expectedException.expectMessage("Failed to load segment");
        for (Future future : futures) {
            future.get();
        }
    }

    private DataSegment newSegment(Interval interval, int partitionId) {
        return DataSegment.builder().dataSource("test_ds").interval(interval).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version(this.segmentVersion).dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)new NumberedShardSpec(partitionId, 0)).binaryVersion(Integer.valueOf(9)).size(1000L).build();
    }
}

