/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalFileTimestampVersionFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalFileTimestampVersionFinderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File tmpDir;
    private LocalFileTimestampVersionFinder finder;

    @Before
    public void setup() throws IOException {
        this.tmpDir = this.temporaryFolder.newFolder();
        this.finder = new LocalFileTimestampVersionFinder();
    }

    @Test
    public void testSimpleLatestVersion() throws IOException, InterruptedException {
        File oldFile = File.createTempFile("old", ".txt", this.tmpDir);
        oldFile.createNewFile();
        Thread.sleep(1000L);
        File newFile = File.createTempFile("new", ".txt", this.tmpDir);
        newFile.createNewFile();
        Assert.assertTrue((boolean)oldFile.exists());
        Assert.assertTrue((boolean)newFile.exists());
        Assert.assertNotEquals((long)oldFile.lastModified(), (long)newFile.lastModified());
        Assert.assertEquals((Object)oldFile.getParentFile(), (Object)newFile.getParentFile());
        Assert.assertEquals((Object)newFile.getAbsolutePath(), (Object)this.finder.getLatestVersion(oldFile.toURI(), Pattern.compile(".*\\.txt")).getPath());
    }

    @Test
    public void testSimpleOneFileLatestVersion() throws IOException {
        File oldFile = File.createTempFile("old", ".txt", this.tmpDir);
        Assert.assertTrue((boolean)oldFile.exists());
        Assert.assertEquals((Object)oldFile.getAbsolutePath(), (Object)this.finder.getLatestVersion(oldFile.toURI(), Pattern.compile(".*\\.txt")).getPath());
    }

    @Test
    public void testSimpleOneFileLatestVersionNullMatcher() throws IOException {
        File oldFile = File.createTempFile("old", ".txt", this.tmpDir);
        Assert.assertTrue((boolean)oldFile.exists());
        Assert.assertEquals((Object)oldFile.getAbsolutePath(), (Object)this.finder.getLatestVersion(oldFile.toURI(), null).getPath());
    }

    @Test
    public void testNoLatestVersion() throws IOException {
        File oldFile = File.createTempFile("test", ".txt", this.tmpDir);
        oldFile.delete();
        URI uri = oldFile.toURI();
        Assert.assertNull((Object)this.finder.getLatestVersion(uri, Pattern.compile(".*\\.txt")));
    }

    @Test
    public void testLatestVersionInDir() throws IOException, InterruptedException {
        File oldFile = File.createTempFile("old", ".txt", this.tmpDir);
        oldFile.createNewFile();
        Thread.sleep(1000L);
        File newFile = File.createTempFile("new", ".txt", this.tmpDir);
        newFile.createNewFile();
        Assert.assertTrue((boolean)oldFile.exists());
        Assert.assertTrue((boolean)newFile.exists());
        Assert.assertEquals((Object)newFile.getAbsolutePath(), (Object)this.finder.getLatestVersion(oldFile.getParentFile().toURI(), Pattern.compile(".*\\.txt")).getPath());
    }

    @Test
    public void testExampleRegex() throws IOException {
        File tmpFile = new File(this.tmpDir, "renames-123.gz");
        tmpFile.createNewFile();
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertFalse((boolean)tmpFile.isDirectory());
        Assert.assertEquals((Object)tmpFile.getAbsolutePath(), (Object)this.finder.getLatestVersion(this.tmpDir.toURI(), Pattern.compile("renames-[0-9]*\\.gz")).getPath());
    }
}

