/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.utils.CompressionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalDataSegmentPullerTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File tmpDir;
    private LocalDataSegmentPuller puller;

    @Before
    public void setup() throws IOException {
        this.tmpDir = this.temporaryFolder.newFolder();
        this.puller = new LocalDataSegmentPuller();
    }

    @After
    public void after() throws IOException {
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test
    public void simpleZipTest() throws IOException, SegmentLoadingException {
        File file = new File(this.tmpDir, "test1data");
        File zipFile = this.temporaryFolder.newFile("ziptest.zip");
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ((OutputStream)outputStream).write(new byte[0]);
            outputStream.flush();
        }
        CompressionUtils.zip((File)this.tmpDir, (File)zipFile);
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)zipFile.exists());
        this.puller.getSegmentFiles(zipFile, this.tmpDir);
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void simpleGZTest() throws IOException, SegmentLoadingException {
        File zipFile = File.createTempFile("gztest", ".gz");
        File unZipFile = new File(this.tmpDir, Files.getNameWithoutExtension((String)zipFile.getAbsolutePath()));
        unZipFile.delete();
        zipFile.delete();
        try (FileOutputStream fOutStream = new FileOutputStream(zipFile);
             GZIPOutputStream outputStream = new GZIPOutputStream(fOutStream);){
            ((OutputStream)outputStream).write(new byte[0]);
            ((OutputStream)outputStream).flush();
        }
        Assert.assertTrue((boolean)zipFile.exists());
        Assert.assertFalse((boolean)unZipFile.exists());
        this.puller.getSegmentFiles(zipFile, this.tmpDir);
        Assert.assertTrue((boolean)unZipFile.exists());
    }

    @Test
    public void simpleDirectoryTest() throws IOException, SegmentLoadingException {
        File srcDir = this.temporaryFolder.newFolder();
        File tmpFile = File.createTempFile("test", "file", srcDir);
        File expectedOutput = new File(this.tmpDir, Files.getNameWithoutExtension((String)tmpFile.getAbsolutePath()));
        Assert.assertFalse((boolean)expectedOutput.exists());
        this.puller.getSegmentFiles(srcDir, this.tmpDir);
        Assert.assertTrue((boolean)expectedOutput.exists());
    }
}

