/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.loading;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.org.apache.druid.java.util.common.MapUtils;
import org.apache.hive.druid.org.apache.druid.segment.AbstractSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class CacheTestSegmentLoader
implements SegmentLoader {
    private final Set<DataSegment> segmentsInTrash = new HashSet<DataSegment>();

    public boolean isSegmentLoaded(DataSegment segment) {
        Map loadSpec = segment.getLoadSpec();
        return new File(MapUtils.getString((Map)loadSpec, (String)"cacheDir")).exists();
    }

    public Segment getSegment(final DataSegment segment, boolean lazy) {
        return new AbstractSegment(){

            public SegmentId getId() {
                return segment.getId();
            }

            public Interval getDataInterval() {
                return segment.getInterval();
            }

            public QueryableIndex asQueryableIndex() {
                throw new UnsupportedOperationException();
            }

            public StorageAdapter asStorageAdapter() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    public File getSegmentFiles(DataSegment segment) {
        throw new UnsupportedOperationException();
    }

    public void cleanup(DataSegment segment) {
        this.segmentsInTrash.add(segment);
    }

    public Set<DataSegment> getSegmentsInTrash() {
        return this.segmentsInTrash;
    }
}

