/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.indexing;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.filter.AndDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.hive.druid.org.apache.druid.segment.transform.TransformSpec;
import org.junit.Assert;
import org.junit.Test;

public class TransformSpecTest {
    private static final MapInputRowParser PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("t", "auto", DateTimes.of((String)"2000-01-01")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"f", (Object)"x", (Object)"y")), null, null)));
    private static final Map<String, Object> ROW1 = ImmutableMap.builder().put((Object)"x", (Object)"foo").put((Object)"y", (Object)"bar").put((Object)"a", (Object)2.0).put((Object)"b", (Object)3L).build();
    private static final Map<String, Object> ROW2 = ImmutableMap.builder().put((Object)"x", (Object)"foo").put((Object)"y", (Object)"baz").put((Object)"a", (Object)2.0).put((Object)"b", (Object)4L).build();

    @Test
    public void testTransforms() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("h", "concat(f,g)", TestExprMacroTable.INSTANCE)));
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)row.getTimestampFromEpoch());
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"f", (Object)"x", (Object)"y"), (Object)row.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)row.getDimension("x"));
        Assert.assertEquals((double)3.0, (double)row.getMetric("b").doubleValue(), (double)0.0);
        Assert.assertEquals((Object)"foobar", (Object)row.getRaw("f"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foobar"), (Object)row.getDimension("f"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"5.0"), (Object)row.getDimension("g"));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)row.getDimension("h"));
        Assert.assertEquals((long)5L, (long)row.getMetric("g").longValue());
    }

    @Test
    public void testTransformOverwriteField() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("x", "concat(x,y)", TestExprMacroTable.INSTANCE)));
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)row.getTimestampFromEpoch());
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"f", (Object)"x", (Object)"y"), (Object)row.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foobar"), (Object)row.getDimension("x"));
        Assert.assertEquals((double)3.0, (double)row.getMetric("b").doubleValue(), (double)0.0);
        Assert.assertNull((Object)row.getRaw("f"));
    }

    @Test
    public void testFilterOnTransforms() {
        TransformSpec transformSpec = new TransformSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("x", "foo", null), (Object)new SelectorDimFilter("f", "foobar", null), (Object)new SelectorDimFilter("g", "5.0", null))), (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE)));
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        Assert.assertNotNull(parser.parseBatch(ROW1).get(0));
        Assert.assertNull(parser.parseBatch(ROW2).get(0));
    }

    @Test
    public void testTransformTimeFromOtherFields() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "(a + b) * 3600000", TestExprMacroTable.INSTANCE)));
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)DateTimes.of((String)"1970-01-01T05:00:00Z"), (Object)row.getTimestamp());
        Assert.assertEquals((long)DateTimes.of((String)"1970-01-01T05:00:00Z").getMillis(), (long)row.getTimestampFromEpoch());
    }

    @Test
    public void testTransformTimeFromTime() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "__time + 3600000", TestExprMacroTable.INSTANCE)));
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01T01:00:00Z"), (Object)row.getTimestamp());
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01T01:00:00Z").getMillis(), (long)row.getTimestampFromEpoch());
    }

    @Test
    public void testSerde() throws Exception {
        TransformSpec transformSpec = new TransformSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("x", "foo", null), (Object)new SelectorDimFilter("f", "foobar", null), (Object)new SelectorDimFilter("g", "5.0", null))), (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE)));
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Assert.assertEquals((Object)transformSpec, (Object)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)transformSpec), TransformSpec.class));
    }
}

