/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.indexing;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.IAE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.TestModifiedDataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.hive.druid.org.apache.druid.segment.transform.TransformSpec;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DataSchemaTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testDefaultExclusions() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA")), null, null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = new DataSchema("test", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"time", (Object)"col1", (Object)"col2", (Object)"metric1", (Object)"metric2"), (Object)schema.getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    public void testExplicitInclude() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2")), (List)ImmutableList.of((Object)"dimC"), null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = new DataSchema("test", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"dimC", (Object)"col1", (Object)"metric1", (Object)"metric2"), (Object)schema.getParser().getParseSpec().getDimensionsSpec().getDimensionExclusions());
    }

    @Test
    public void testTransformSpec() {
        Map parserMap = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2")), (List)ImmutableList.of(), null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = new DataSchema("test", parserMap, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), new TransformSpec((DimFilter)new SelectorDimFilter("dimA", "foo", null), (List)ImmutableList.of((Object)new ExpressionTransform("expr", "concat(dimA,dimA)", TestExprMacroTable.INSTANCE))), this.jsonMapper);
        StringInputRowParser parser = (StringInputRowParser)schema.getParser();
        InputRow row1bb = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1bb.getTimestamp());
        Assert.assertEquals((Object)"foo", (Object)row1bb.getRaw("dimA"));
        Assert.assertEquals((Object)"foofoo", (Object)row1bb.getRaw("expr"));
        InputRow row1string = parser.parse("{\"time\":\"2000-01-01\",\"dimA\":\"foo\"}");
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row1string.getTimestamp());
        Assert.assertEquals((Object)"foo", (Object)row1string.getRaw("dimA"));
        Assert.assertEquals((Object)"foofoo", (Object)row1string.getRaw("expr"));
        InputRow row2 = (InputRow)parser.parseBatch(ByteBuffer.wrap("{\"time\":\"2000-01-01\",\"dimA\":\"x\"}".getBytes(StandardCharsets.UTF_8))).get(0);
        Assert.assertNull((Object)row2);
    }

    @Test(expected=IAE.class)
    public void testOverlapMetricNameAndDim() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"metric1")), (List)ImmutableList.of((Object)"dimC"), null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = new DataSchema("test", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
        schema.getParser();
    }

    @Test(expected=IAE.class)
    public void testDuplicateAggregators() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time")), (List)ImmutableList.of((Object)"dimC"), null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema schema = new DataSchema("test", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2"), new DoubleSumAggregatorFactory("metric1", "col3")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
        schema.getParser();
    }

    @Test
    public void testSerdeWithInvalidParserMap() throws Exception {
        String jsonStr = "{\"dataSource\":\"test\",\"parser\":{\"type\":\"invalid\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema schema = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectCause(CoreMatchers.instanceOf(JsonMappingException.class));
        this.expectedException.expectMessage("Cannot construct instance of `org.apache.druid.data.input.impl.StringInputRowParser`, problem: parseSpec");
        schema.getParser();
    }

    @Test
    public void testEmptyDatasource() {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"dimA", (Object)"dimB", (Object)"col2")), (List)ImmutableList.of((Object)"dimC"), null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectMessage("dataSource cannot be null or empty. Please provide a dataSource.");
        DataSchema schema = new DataSchema("", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
    }

    @Test
    public void testInvalidWhitespaceDatasource() {
        ImmutableMap invalidCharToDataSourceName = ImmutableMap.of((Object)"\\t", (Object)"\tab\t", (Object)"\\r", (Object)"\rcarriage\return\r", (Object)"\\n", (Object)"\nnew\nline\n");
        for (Map.Entry entry : invalidCharToDataSourceName.entrySet()) {
            this.testInvalidWhitespaceDatasourceHelper((String)entry.getValue(), (String)entry.getKey());
        }
    }

    private void testInvalidWhitespaceDatasourceHelper(String dataSource, String invalidChar) {
        String testFailMsg = "dataSource contain invalid whitespace character: " + invalidChar;
        try {
            DataSchema schema = new DataSchema(dataSource, Collections.emptyMap(), null, null, null, this.jsonMapper);
            Assert.fail((String)testFailMsg);
        }
        catch (IllegalArgumentException errorMsg) {
            String expectedMsg = "dataSource cannot contain whitespace character except space.";
            Assert.assertEquals((String)testFailMsg, (Object)expectedMsg, (Object)errorMsg.getMessage());
        }
    }

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\"dataSource\":\"test\",\"parser\":{\"type\":\"string\",\"parseSpec\":{\"format\":\"json\",\"timestampSpec\":{\"column\":\"xXx\", \"format\": \"auto\", \"missingValue\": null},\"dimensionsSpec\":{\"dimensions\":[], \"dimensionExclusions\":[]},\"flattenSpec\":{\"useFieldDiscovery\":true, \"fields\":[]},\"featureSpec\":{}},\"encoding\":\"UTF-8\"},\"metricsSpec\":[{\"type\":\"doubleSum\",\"name\":\"metric1\",\"fieldName\":\"col1\"}],\"granularitySpec\":{\"type\":\"arbitrary\",\"queryGranularity\":{\"type\":\"duration\",\"duration\":86400000,\"origin\":\"1970-01-01T00:00:00.000Z\"},\"intervals\":[\"2014-01-01T00:00:00.000Z/2015-01-01T00:00:00.000Z\"]}}";
        DataSchema actual = (DataSchema)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString(this.jsonMapper.readValue(jsonStr, DataSchema.class)), DataSchema.class);
        Assert.assertEquals((Object)actual.getDataSource(), (Object)"test");
        Assert.assertEquals((Object)actual.getParser().getParseSpec(), (Object)new JSONParseSpec(new TimestampSpec("xXx", null, null), new DimensionsSpec(null, Arrays.asList("metric1", "xXx", "col1"), null), null, null));
        Assert.assertArrayEquals((Object[])actual.getAggregators(), (Object[])new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1")});
        Assert.assertEquals((Object)actual.getGranularitySpec(), (Object)new ArbitraryGranularitySpec((Granularity)new DurationGranularity(86400000L, null), (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))));
    }

    @Test
    public void testSerdeWithUpdatedDataSchemaAddedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA")), null, null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        DataSchema originalSchema = new DataSchema("test", parser, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, this.jsonMapper);
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        TestModifiedDataSchema deserialized = (TestModifiedDataSchema)((Object)this.jsonMapper.readValue(serialized, TestModifiedDataSchema.class));
        Assert.assertEquals(null, (Object)deserialized.getExtra());
        Assert.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assert.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assert.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assert.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assert.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assert.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }

    @Test
    public void testSerdeWithUpdatedDataSchemaRemovedField() throws IOException {
        Map parser = (Map)this.jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("time", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dimB", (Object)"dimA")), null, null), null, null), null), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        TestModifiedDataSchema originalSchema = new TestModifiedDataSchema("test", null, null, new AggregatorFactory[]{new DoubleSumAggregatorFactory("metric1", "col1"), new DoubleSumAggregatorFactory("metric2", "col2")}, (GranularitySpec)new ArbitraryGranularitySpec(Granularities.DAY, (List)ImmutableList.of((Object)Intervals.of((String)"2014/2015"))), null, parser, this.jsonMapper, "some arbitrary string");
        String serialized = this.jsonMapper.writeValueAsString((Object)originalSchema);
        DataSchema deserialized = (DataSchema)this.jsonMapper.readValue(serialized, DataSchema.class);
        Assert.assertEquals((Object)originalSchema.getDataSource(), (Object)deserialized.getDataSource());
        Assert.assertEquals((Object)originalSchema.getGranularitySpec(), (Object)deserialized.getGranularitySpec());
        Assert.assertEquals((Object)originalSchema.getParser().getParseSpec(), (Object)deserialized.getParser().getParseSpec());
        Assert.assertArrayEquals((Object[])originalSchema.getAggregators(), (Object[])deserialized.getAggregators());
        Assert.assertEquals((Object)originalSchema.getTransformSpec(), (Object)deserialized.getTransformSpec());
        Assert.assertEquals((Object)originalSchema.getParserMap(), (Object)deserialized.getParserMap());
    }
}

