/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongMaxAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OnheapIncrementalIndexTest
extends InitializedNullHandlingTest {
    private static final int MAX_ROWS = 100000;

    @Test
    public void testMultithreadAddFacts() throws Exception {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongMaxAggregatorFactory("max", "max")}).build()).setMaxRowCount(100000).buildOnheap();
        int addThreadCount = 2;
        Thread[] addThreads = new Thread[2];
        for (int i = 0; i < 2; ++i) {
            addThreads[i] = new Thread(new Runnable((IncrementalIndex)index){
                final /* synthetic */ IncrementalIndex val$index;
                {
                    this.val$index = incrementalIndex;
                }

                @Override
                public void run() {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    try {
                        for (int j = 0; j < 50000; ++j) {
                            this.val$index.add((InputRow)new MapBasedInputRow(0L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)((Random)random).nextLong(), (Object)"max", (Object)1)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            addThreads[i].start();
        }
        AtomicInteger checkFailedCount = new AtomicInteger(0);
        Thread checkThread = new Thread(new Runnable((IncrementalIndex)index, checkFailedCount){
            final /* synthetic */ IncrementalIndex val$index;
            final /* synthetic */ AtomicInteger val$checkFailedCount;
            {
                this.val$index = incrementalIndex;
                this.val$checkFailedCount = atomicInteger;
            }

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    for (IncrementalIndexRow row : this.val$index.getFacts().keySet()) {
                        if (this.val$index.getMetricLongValue(row.getRowIndex(), 0) == 1L) continue;
                        this.val$checkFailedCount.addAndGet(1);
                    }
                }
            }
        });
        checkThread.start();
        for (int i = 0; i < 2; ++i) {
            addThreads[i].join();
        }
        checkThread.interrupt();
        Assert.assertEquals((long)0L, (long)checkFailedCount.get());
    }

    @Test
    public void testMultithreadAddFactsUsingExpressionAndJavaScript() throws Exception {
        int i;
        OnheapIncrementalIndex indexExpr = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("oddnum", null, "if(value%2==1,1,0)", TestExprMacroTable.INSTANCE)}).withRollup(true).build()).setMaxRowCount(100000).buildOnheap();
        OnheapIncrementalIndex indexJs = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new JavaScriptAggregatorFactory("oddnum", (List)ImmutableList.of((Object)"value"), "function(current, value) { if (value%2==1) current = current + 1; return current;}", "function() {return 0;}", "function(a, b) { return a + b;}", JavaScriptConfig.getEnabledInstance())}).withRollup(true).build()).setMaxRowCount(100000).buildOnheap();
        int addThreadCount = 2;
        Thread[] addThreads = new Thread[2];
        for (i = 0; i < 2; ++i) {
            addThreads[i] = new Thread(new Runnable((IncrementalIndex)indexExpr, (IncrementalIndex)indexJs){
                final /* synthetic */ IncrementalIndex val$indexExpr;
                final /* synthetic */ IncrementalIndex val$indexJs;
                {
                    this.val$indexExpr = incrementalIndex;
                    this.val$indexJs = incrementalIndex2;
                }

                @Override
                public void run() {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    try {
                        for (int j = 0; j < 50000; ++j) {
                            int randomInt = ((Random)random).nextInt(100000);
                            MapBasedInputRow mapBasedInputRowExpr = new MapBasedInputRow(0L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)(randomInt % 3), (Object)"value", (Object)randomInt));
                            MapBasedInputRow mapBasedInputRowJs = new MapBasedInputRow(0L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)(randomInt % 3), (Object)"value", (Object)randomInt));
                            this.val$indexExpr.add((InputRow)mapBasedInputRowExpr);
                            this.val$indexJs.add((InputRow)mapBasedInputRowJs);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            addThreads[i].start();
        }
        for (i = 0; i < 2; ++i) {
            addThreads[i].join();
        }
        long exprSum = 0L;
        long jsSum = 0L;
        for (IncrementalIndexRow row : indexExpr.getFacts().keySet()) {
            exprSum += indexExpr.getMetricLongValue(row.getRowIndex(), 0);
        }
        for (IncrementalIndexRow row : indexJs.getFacts().keySet()) {
            jsSum += indexJs.getMetricLongValue(row.getRowIndex(), 0);
        }
        Assert.assertEquals((long)exprSum, (long)jsSum);
    }

    @Test
    public void testOnHeapIncrementalIndexClose() throws Exception {
        Aggregator mockedAggregator = (Aggregator)EasyMock.createMock(LongMaxAggregator.class);
        mockedAggregator.close();
        EasyMock.expectLastCall().times(1);
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withMetrics(new AggregatorFactory[]{new LongMaxAggregatorFactory("max", "max")}).build()).setMaxRowCount(100000).buildOnheap();
        index.add((InputRow)new MapBasedInputRow(0L, Collections.singletonList("billy"), (Map)ImmutableMap.of((Object)"billy", (Object)1, (Object)"max", (Object)1)));
        index.concurrentGet((int)0)[0] = mockedAggregator;
        EasyMock.replay((Object[])new Object[]{mockedAggregator});
        index.close();
        EasyMock.verify((Object[])new Object[]{mockedAggregator});
    }
}

