/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.collections.CloseableStupidPool;
import org.apache.hive.druid.org.apache.druid.collections.NonBlockingPool;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.segment.CloserRule;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexTest
extends InitializedNullHandlingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final CloserRule closerRule = new CloserRule(false);
    private final IndexCreator indexCreator;
    private final Closer resourceCloser;

    @After
    public void teardown() throws IOException {
        this.resourceCloser.close();
    }

    public IncrementalIndexTest(IndexCreator IndexCreator2, Closer resourceCloser) {
        this.indexCreator = IndexCreator2;
        this.resourceCloser = resourceCloser;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        DimensionsSpec dimensions = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string"), new FloatDimensionSchema("float"), new LongDimensionSchema("long"), new DoubleDimensionSchema("double")), null, null);
        AggregatorFactory[] metrics = new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("cnt"), (DimFilter)new SelectorDimFilter("billy", "A", null))};
        final IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withQueryGranularity(Granularities.MINUTE).withDimensionsSpec(dimensions).withMetrics(metrics).build();
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (final Boolean sortFacts : ImmutableList.of((Object)false, (Object)true)) {
            constructors.add(new Object[]{new IndexCreator(){

                @Override
                public IncrementalIndex createIndex() {
                    return new IncrementalIndex.Builder().setIndexSchema(schema).setDeserializeComplexMetrics(false).setSortFacts(sortFacts.booleanValue()).setMaxRowCount(1000).buildOnheap();
                }
            }, Closer.create()});
            Closer poolCloser = Closer.create();
            final CloseableStupidPool stupidPool = new CloseableStupidPool("OffheapIncrementalIndex-bufferPool", () -> ByteBuffer.allocate(262144));
            poolCloser.register(stupidPool);
            constructors.add(new Object[]{new IndexCreator(){

                @Override
                public IncrementalIndex createIndex() {
                    return new IncrementalIndex.Builder().setIndexSchema(schema).setSortFacts(sortFacts.booleanValue()).setMaxRowCount(1000000).buildOffheap((NonBlockingPool)stupidPool);
                }
            }, poolCloser});
        }
        return constructors;
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensions() throws IndexSizeExceededException {
        IncrementalIndex index = this.closerRule.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test(expected=ISE.class)
    public void testDuplicateDimensionsFirstOccurrence() throws IndexSizeExceededException {
        IncrementalIndex index = this.closerRule.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void controlTest() throws IndexSizeExceededException {
        IncrementalIndex index = this.closerRule.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"C", (Object)"joe", (Object)"B")));
        index.add((InputRow)new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B")));
    }

    @Test
    public void testUnparseableNumerics() throws IndexSizeExceededException {
        IncrementalIndex index = this.closerRule.closeLater(this.indexCreator.createIndex());
        IncrementalIndexAddResult result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"19.0", (Object)"long", (Object)"asdj", (Object)"double", (Object)21.0)));
        Assert.assertEquals(ParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"Found unparseable columns in row: [MapBasedInputRow{timestamp=1970-01-01T00:00:00.000Z, event={string=A, float=19.0, long=asdj, double=21.0}, dimensions=[string, float, long, double]}], exceptions: [could not convert value [asdj] to long,]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)"aaa", (Object)"long", (Object)20, (Object)"double", (Object)21.0)));
        Assert.assertEquals(ParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"Found unparseable columns in row: [MapBasedInputRow{timestamp=1970-01-01T00:00:00.000Z, event={string=A, float=aaa, long=20, double=21.0}, dimensions=[string, float, long, double]}], exceptions: [could not convert value [aaa] to float,]", (Object)result.getParseException().getMessage());
        result = index.add((InputRow)new MapBasedInputRow(0L, (List)Lists.newArrayList((Object[])new String[]{"string", "float", "long", "double"}), (Map)ImmutableMap.of((Object)"string", (Object)"A", (Object)"float", (Object)19.0, (Object)"long", (Object)20, (Object)"double", (Object)"")));
        Assert.assertEquals(ParseException.class, result.getParseException().getClass());
        Assert.assertEquals((Object)"Found unparseable columns in row: [MapBasedInputRow{timestamp=1970-01-01T00:00:00.000Z, event={string=A, float=19.0, long=20, double=}, dimensions=[string, float, long, double]}], exceptions: [could not convert value [] to double,]", (Object)result.getParseException().getMessage());
    }

    @Test
    public void sameRow() throws IndexSizeExceededException {
        MapBasedInputRow row = new MapBasedInputRow(System.currentTimeMillis() - 1L, (List)Lists.newArrayList((Object[])new String[]{"billy", "joe"}), (Map)ImmutableMap.of((Object)"billy", (Object)"A", (Object)"joe", (Object)"B"));
        IncrementalIndex index = this.closerRule.closeLater(this.indexCreator.createIndex());
        index.add((InputRow)row);
        index.add((InputRow)row);
        index.add((InputRow)row);
        Assert.assertEquals((long)1L, (long)index.size());
    }

    static interface IndexCreator {
        public IncrementalIndex createIndex();
    }
}

