/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexRowSizeTest
extends InitializedNullHandlingTest {
    @Test
    public void testIncrementalIndexRowSizeBasic() {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(10000).setMaxBytesInMemory(1000L).buildOnheap();
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time, "billy", "A", "joe", "B"));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)44L, (long)td1.estimateBytesInMemory());
    }

    @Test
    public void testIncrementalIndexRowSizeArr() {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(10000).setMaxBytesInMemory(1000L).buildOnheap();
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", Arrays.asList("A", "B")));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)50L, (long)td1.estimateBytesInMemory());
    }

    @Test
    public void testIncrementalIndexRowSizeComplex() {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(10000).setMaxBytesInMemory(1000L).buildOnheap();
        long time = System.currentTimeMillis();
        IncrementalIndex.IncrementalIndexRowResult tndResult = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "nelson", "joe", Arrays.asList("123", "abcdef")));
        IncrementalIndexRow td1 = tndResult.getIncrementalIndexRow();
        Assert.assertEquals((long)74L, (long)td1.estimateBytesInMemory());
    }

    private MapBasedInputRow toMapRow(long time, Object ... dimAndVal) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < dimAndVal.length; i += 2) {
            data.put((String)dimAndVal[i], dimAndVal[i + 1]);
        }
        return new MapBasedInputRow(time, (List)Lists.newArrayList(data.keySet()), data);
    }
}

