/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexRowCompTest
extends InitializedNullHandlingTest {
    @Test
    public void testBasic() {
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(1000).buildOnheap();
        long time = System.currentTimeMillis();
        IncrementalIndexRow ir1 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time, "billy", "A", "joe", "B")).getIncrementalIndexRow();
        IncrementalIndexRow ir2 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time, "billy", "A", "joe", "A")).getIncrementalIndexRow();
        IncrementalIndexRow ir3 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time, "billy", "A")).getIncrementalIndexRow();
        IncrementalIndexRow ir4 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", "B")).getIncrementalIndexRow();
        IncrementalIndexRow ir5 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", Arrays.asList("A", "B"))).getIncrementalIndexRow();
        IncrementalIndexRow ir6 = index.toIncrementalIndexRow((InputRow)this.toMapRow(time + 1L, new Object[0])).getIncrementalIndexRow();
        Comparator comparator = index.dimsComparator();
        Assert.assertEquals((long)0L, (long)comparator.compare(ir1, ir1));
        Assert.assertEquals((long)0L, (long)comparator.compare(ir2, ir2));
        Assert.assertEquals((long)0L, (long)comparator.compare(ir3, ir3));
        Assert.assertTrue((comparator.compare(ir1, ir2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir2, ir1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir2, ir3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir3, ir2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir1, ir3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir3, ir1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir6, ir1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir6, ir2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir6, ir3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir4, ir6) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir5, ir6) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir4, ir5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(ir5, ir4) > 0 ? 1 : 0) != 0);
    }

    private MapBasedInputRow toMapRow(long time, Object ... dimAndVal) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < dimAndVal.length; i += 2) {
            data.put((String)dimAndVal[i], dimAndVal[i + 1]);
        }
        return new MapBasedInputRow(time, (List)Lists.newArrayList(data.keySet()), data);
    }
}

