/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexMultiValueSpecTest
extends InitializedNullHandlingTest {
    @Test
    public void test() throws IndexSizeExceededException {
        DimensionsSpec dimensionsSpec = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("string1", DimensionSchema.MultiValueHandling.ARRAY, Boolean.valueOf(true)), new StringDimensionSchema("string2", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true)), new StringDimensionSchema("string3", DimensionSchema.MultiValueHandling.SORTED_SET, Boolean.valueOf(true))), null, null);
        IncrementalIndexSchema schema = new IncrementalIndexSchema(0L, new TimestampSpec("ds", "auto", null), Granularities.ALL, VirtualColumns.EMPTY, dimensionsSpec, new AggregatorFactory[0], false);
        HashMap<String, Object> map = new HashMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if (((String)key).startsWith("string")) {
                    return Arrays.asList("xsd", "aba", "fds", "aba");
                }
                if (((String)key).startsWith("float")) {
                    return Arrays.asList(Float.valueOf(3.92f), Float.valueOf(-2.76f), Float.valueOf(42.153f), Float.valueOf(Float.NaN), Float.valueOf(-2.76f), Float.valueOf(-2.76f));
                }
                if (((String)key).startsWith("long")) {
                    return Arrays.asList(-231238789L, 328L, 923L, 328L, -2L, 0L);
                }
                return null;
            }
        };
        OnheapIncrementalIndex index = new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(10000).buildOnheap();
        index.add((InputRow)new MapBasedInputRow(0L, Arrays.asList("string1", "string2", "string3", "float1", "float2", "float3", "long1", "long2", "long3"), (Map)map));
        Row row = (Row)index.iterator().next();
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"xsd", "aba", "fds", "aba"}), (Object)row.getRaw("string1"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"aba", "aba", "fds", "xsd"}), (Object)row.getRaw("string2"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"aba", "fds", "xsd"}), (Object)row.getRaw("string3"));
    }
}

