/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.incremental;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.TransformableRowIterator;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapValues;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class IncrementalIndexAdapterTest
extends InitializedNullHandlingTest {
    private static final IndexSpec INDEX_SPEC = new IndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);

    @Test
    public void testGetBitmapIndex() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex incrementalIndex = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, incrementalIndex);
        IncrementalIndexAdapter adapter = new IncrementalIndexAdapter(incrementalIndex.getInterval(), incrementalIndex, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        String dimension = "dim1";
        try (CloseableIndexed dimValueLookup = adapter.getDimValueLookup(dimension);){
            for (int i = 0; i < dimValueLookup.size(); ++i) {
                BitmapValues bitmapValues = adapter.getBitmapValues(dimension, i);
                Assert.assertEquals((long)1L, (long)bitmapValues.size());
            }
        }
    }

    @Test
    public void testGetRowsIterable() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        TransformableRowIterator rows = incrementalAdapter.getRows();
        ArrayList<Integer> rowNums = new ArrayList<Integer>();
        while (rows.moveToNext()) {
            rowNums.add(rows.getPointer().getRowNum());
        }
        Assert.assertEquals((long)2L, (long)rowNums.size());
        Assert.assertEquals((long)0L, (long)((Integer)rowNums.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)rowNums.get(1)).intValue());
    }

    @Test
    public void testGetRowsIterableNoRollup() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createNoRollupIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        ArrayList<Integer> dim1Vals = new ArrayList<Integer>();
        for (Object row : toPersist1.getFacts().keySet()) {
            dim1Vals.add(((int[])row.getDims()[0])[0]);
        }
        ArrayList<Integer> dim2Vals = new ArrayList<Integer>();
        for (IncrementalIndexRow row : toPersist1.getFacts().keySet()) {
            dim2Vals.add(((int[])row.getDims()[1])[0]);
        }
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        TransformableRowIterator rows = incrementalAdapter.getRows();
        ArrayList<String> rowStrings = new ArrayList<String>();
        while (rows.moveToNext()) {
            rowStrings.add(rows.getPointer().toString());
        }
        Function<Integer, String> getExpected = rowNumber -> {
            if (rowNumber < 3) {
                return StringUtils.format((String)"RowPointer{indexNum=0, rowNumber=%s, timestamp=%s, dimensions={dim1=1, dim2=2}, metrics={count=1}}", (Object[])new Object[]{rowNumber, timestamp});
            }
            return StringUtils.format((String)"RowPointer{indexNum=0, rowNumber=%s, timestamp=%s, dimensions={dim1=3, dim2=4}, metrics={count=1}}", (Object[])new Object[]{rowNumber, timestamp});
        };
        Assert.assertEquals((long)6L, (long)rowStrings.size());
        for (int i = 0; i < 6; ++i) {
            if (i % 2 == 0) {
                Assert.assertEquals((long)0L, (long)((Integer)dim1Vals.get(i)).intValue());
                Assert.assertEquals((long)0L, (long)((Integer)dim2Vals.get(i)).intValue());
            } else {
                Assert.assertEquals((long)1L, (long)((Integer)dim1Vals.get(i)).intValue());
                Assert.assertEquals((long)1L, (long)((Integer)dim2Vals.get(i)).intValue());
            }
            Assert.assertEquals((Object)getExpected.apply(i), rowStrings.get(i));
        }
    }
}

