/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.hive.druid.org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.segment.IndexBuilder;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"abdef", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0));

    public SearchQueryFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(SearchQueryFilterTest.class.getName());
    }

    private SearchQuerySpec specForValue(String value) {
        return new ContainsSearchQuerySpec(value, true);
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue("0"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim0", this.specForValue("5"), null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("10"), null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("2"), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("1"), null), (List<String>)ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("def"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("abc"), null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), null), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testMultiValueStringColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue(""), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("a"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("b"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("c"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("d"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSearchQueryWithExtractionFn() {
        String nullJsFn = "function(str) { if (str === null) { return 'NOT_NULL_ANYMORE'; } else { return str;} }";
        JavaScriptExtractionFn changeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        }
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim1", this.specForValue("ab"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim2", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim3", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("ANYMORE"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter("dim4", this.specForValue("a"), (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
    }
}

