/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.segment.IndexBuilder;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaScriptFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0));
    private final String jsNullFilter = "function(x) { return(x === null) }";

    public JavaScriptFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(JavaScriptFilterTest.class.getName());
    }

    private String jsValueFilter(String value) {
        String jsFn = "function(x) { return(x === '" + value + "') }";
        return jsFn;
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("0"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("1"), null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter(""), null), (List<String>)ImmutableList.of((Object)"0"));
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("10"), null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("2"), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("1"), null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("def"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("abc"), null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("ab"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiValueStringColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter(""), null), (List<String>)ImmutableList.of((Object)"2"));
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("d"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", "function(x) { return(x === null) }", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testJavascriptFilterWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"1", (Object)"HELLO", (Object)"a", (Object)"HELLO", (Object)"def", (Object)"HELLO", (Object)"abc", (Object)"UNKNOWN");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    private JavaScriptDimFilter newJavaScriptDimFilter(String dimension, String function, ExtractionFn extractionFn) {
        return new JavaScriptDimFilter(dimension, function, extractionFn, JavaScriptConfig.getEnabledInstance());
    }
}

