/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.InDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.RegexDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuerySpec;
import org.apache.hive.druid.org.apache.druid.segment.IndexBuilder;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FloatAndDoubleFilteringTest
extends BaseFilterTest {
    private static final String FLOAT_COLUMN = "flt";
    private static final String DOUBLE_COLUMN = "dbl";
    private static final String TIMESTAMP_COLUMN = "ts";
    private static int EXECUTOR_NUM_THREADS = 16;
    private static int EXECUTOR_NUM_TASKS = 2000;
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("ts", "millis", DateTimes.of((String)"2000")), new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dim0"), (Object)new FloatDimensionSchema("flt"), (Object)new DoubleDimensionSchema("dbl")), null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)1L, (Object)"dim0", (Object)"1", (Object)"flt", (Object)Float.valueOf(1.0f), (Object)"dbl", (Object)1.0)).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)2L, (Object)"dim0", (Object)"2", (Object)"flt", (Object)Float.valueOf(2.0f), (Object)"dbl", (Object)2.0)).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)3L, (Object)"dim0", (Object)"3", (Object)"flt", (Object)Float.valueOf(3.0f), (Object)"dbl", (Object)3.0)).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)4L, (Object)"dim0", (Object)"4", (Object)"flt", (Object)Float.valueOf(4.0f), (Object)"dbl", (Object)4.0)).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)5L, (Object)"dim0", (Object)"5", (Object)"flt", (Object)Float.valueOf(5.0f), (Object)"dbl", (Object)5.0)).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)6L, (Object)"dim0", (Object)"6", (Object)"flt", (Object)Float.valueOf(6.0f), (Object)"dbl", (Object)6.0)).get(0));

    public FloatAndDoubleFilteringTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder.schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(PARSER.getParseSpec().getDimensionsSpec()).build()), finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(FloatAndDoubleFilteringTest.class.getName());
    }

    @Test
    public void testFloatColumnFiltering() {
        this.doTestFloatColumnFiltering(FLOAT_COLUMN);
        this.doTestFloatColumnFiltering(DOUBLE_COLUMN);
    }

    @Test
    public void testFloatColumnFilteringWithNonNumbers() {
        this.doTestFloatColumnFilteringWithNonNumbers(FLOAT_COLUMN);
        this.doTestFloatColumnFilteringWithNonNumbers(DOUBLE_COLUMN);
    }

    @Test
    public void testFloatFilterWithExtractionFn() {
        this.doTestFloatFilterWithExtractionFn(FLOAT_COLUMN);
        this.doTestFloatFilterWithExtractionFn(DOUBLE_COLUMN);
    }

    @Test
    public void testMultithreaded() {
        this.doTestMultithreaded(FLOAT_COLUMN);
        this.doTestMultithreaded(DOUBLE_COLUMN);
    }

    private void doTestFloatColumnFiltering(String columnName) {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "3", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "3.0", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "2", "5", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "2.0", "5.0", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "1", "4", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "1.0", "4.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new InDimFilter(columnName, Arrays.asList("2", "4", "8"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFilterMatches((DimFilter)new InDimFilter(columnName, Arrays.asList("2.0", "4.0", "8.0"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        ArrayList<String> infilterValues = new ArrayList<String>(32);
        for (int i = 0; i < 32; ++i) {
            infilterValues.add(String.valueOf(i * 2));
        }
        this.assertFilterMatches((DimFilter)new InDimFilter(columnName, infilterValues, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4", (Object)"6"));
        String jsFn = "function(x) { return(x === 3 || x === 5) }";
        this.assertFilterMatchesSkipVectorize((DimFilter)new JavaScriptDimFilter(columnName, jsFn, null, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"5"));
        String jsFn2 = "function(x) { return(x === 3.0 || x === 5.0) }";
        this.assertFilterMatchesSkipVectorize((DimFilter)new JavaScriptDimFilter(columnName, jsFn2, null, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter(columnName, "4", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter(columnName, "4.0", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter(columnName, (SearchQuerySpec)new ContainsSearchQuerySpec("2", true), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter(columnName, (SearchQuerySpec)new ContainsSearchQuerySpec("2", true), null), (List<String>)ImmutableList.of((Object)"2"));
    }

    private void doTestFloatColumnFilteringWithNonNumbers(String columnName) {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "abc", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "a", "b", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, " ", "4", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, " ", "4", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, " ", "4.0", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, " ", "A", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, " ", "A", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
    }

    private void doTestFloatFilterWithExtractionFn(String columnName) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("1.0", "Monday");
        stringMap.put("2.0", "Tuesday");
        stringMap.put("3.0", "Wednesday");
        stringMap.put("4.0", "Thursday");
        stringMap.put("5.0", "Friday");
        stringMap.put("6.0", "Saturday");
        MapLookupExtractor mapExtractor = new MapLookupExtractor(stringMap, false);
        LookupExtractionFn exfn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "Monday", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(columnName, "Notaday", (ExtractionFn)exfn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "Fridax", "Fridaz", Boolean.valueOf(false), Boolean.valueOf(false), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "Friday", "Friday", Boolean.valueOf(true), Boolean.valueOf(true), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new InDimFilter(columnName, Arrays.asList("Caturday", "Saturday", "Tuesday"), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"6"));
        List<String> bigList = Arrays.asList("Saturday", "Tuesday", "Caturday", "Xanaday", "Vojuday", "Gribaday", "Kipoday", "Dheferday", "Fakeday", "Qeearaday", "Hello", "World", "1", "2", "3", "4", "5", "6", "7");
        this.assertFilterMatches((DimFilter)new InDimFilter(columnName, bigList, (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"6"));
        String jsFn = "function(x) { return(x === 'Wednesday' || x === 'Thursday') }";
        this.assertFilterMatchesSkipVectorize((DimFilter)new JavaScriptDimFilter(columnName, jsFn, (ExtractionFn)exfn, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter(columnName, ".*day", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter(columnName, (SearchQuerySpec)new ContainsSearchQuerySpec("s", true), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
    }

    private void doTestMultithreaded(String columnName) {
        this.assertFilterMatchesMultithreaded((DimFilter)new SelectorDimFilter(columnName, "3", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesMultithreaded((DimFilter)new SelectorDimFilter(columnName, "3.0", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesMultithreaded((DimFilter)new InDimFilter(columnName, Arrays.asList("2", "4", "8"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFilterMatchesMultithreaded((DimFilter)new InDimFilter(columnName, Arrays.asList("2.0", "4.0", "8.0"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        ArrayList<String> infilterValues = new ArrayList<String>(32);
        for (int i = 0; i < 32; ++i) {
            infilterValues.add(String.valueOf(i * 2));
        }
        this.assertFilterMatchesMultithreaded((DimFilter)new InDimFilter(columnName, infilterValues, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "2", "5", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(columnName, "2.0", "5.0", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    private void assertFilterMatchesMultithreaded(DimFilter filter, List<String> expectedRows) {
        this.testWithExecutor(filter, expectedRows);
    }

    private Runnable makeFilterRunner(DimFilter filter, List<String> expectedRows) {
        return () -> this.assertFilterMatches(filter, expectedRows);
    }

    private void testWithExecutor(DimFilter filter, List<String> expectedRows) {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(EXECUTOR_NUM_THREADS));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < EXECUTOR_NUM_TASKS; ++i) {
            Runnable runnable = this.makeFilterRunner(filter, expectedRows);
            ListenableFuture fut = executor.submit(runnable);
            futures.add(fut);
        }
        try {
            Futures.allAsList(futures).get(60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        executor.shutdown();
    }
}

