/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.apache.hive.druid.org.apache.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.hive.druid.org.apache.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.ordering.StringComparators;
import org.apache.hive.druid.org.apache.druid.segment.IndexBuilder;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BoundFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(null, null, null)));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"abc")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"6", (Object)"dim1", (Object)"-1000", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"7", (Object)"dim1", (Object)"-10.012", (Object)"dim2", (Object)ImmutableList.of((Object)"d"))).get(0));

    public BoundFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(BoundFilterTest.class.getName());
    }

    @Test
    public void testLexicographicMatchEverything() {
        ImmutableList filters = ImmutableList.of((Object)new BoundDimFilter("dim0", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim1", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim2", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim3", null, "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC));
        for (BoundDimFilter filter : filters) {
            this.assertFilterMatches((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        }
    }

    @Test
    public void testLexicographicMatchWithEmptyString() {
        ImmutableList filters = ImmutableList.of((Object)new BoundDimFilter("dim0", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim1", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim2", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (Object)new BoundDimFilter("dim3", "", "z", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC));
        if (NullHandling.replaceWithDefault()) {
            for (BoundDimFilter filter : filters) {
                this.assertFilterMatches((DimFilter)filter, (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            }
        } else {
            this.assertFilterMatches((DimFilter)filters.get(0), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)filters.get(1), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)filters.get(2), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)filters.get(3), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testLexicographicMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"2"));
        }
    }

    @Test
    public void testLexicographicMatchMissingColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        if (NullHandling.sqlCompatible()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", null, "", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testLexicographicMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testLexicographicMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "abc", "abc", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testLexicographicMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "ab", "abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testLexicographicMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "ab", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testLexicographicMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testLexicographicMatchNumbers() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testAlphaNumericMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testAlphaNumericMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testAlphaNumericMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"2"));
    }

    @Test
    public void testAlphaNumericMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "ZZZZZ", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testAlphaNumericMatchWithNegatives() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-2000", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "3", "-2000", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericMatchNull() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        }
    }

    @Test
    public void testNumericMatchTooStrict() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testNumericMatchVirtualColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("expr", "1", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new BoundDimFilter("expr", "2", "3", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
    }

    @Test
    public void testNumericMatchExactlySingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "2", "2", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-10.012", "-10.012", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"7"));
    }

    @Test
    public void testNumericMatchSurroundingSingleValue() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-11", "-10", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"7"));
    }

    @Test
    public void testNumericMatchNoUpperLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "1", null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
    }

    @Test
    public void testNumericMatchNoLowerLimit() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", null, "2", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }

    @Test
    public void testNumericMatchWithNegatives() {
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "-2000", "3", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"6", (Object)"7"));
    }

    @Test
    public void testMatchWithExtractionFn() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String nullJsFn = "function(str) { return null; }";
        JavaScriptExtractionFn makeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)makeNullFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim0", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)makeNullFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "super-ab", "super-abd", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim1", "super-0", "super-10", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), (ExtractionFn)superFn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-", "super-zzzzzz", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        } else {
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-", "super-", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new BoundDimFilter("dim2", "super-", "super-", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2"));
        }
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim3", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim4", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter("dim4", "super-null", "super-null", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), (ExtractionFn)superFn, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
    }
}

