/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.filter;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.UnmodifiableIterator;
import org.apache.hive.druid.org.apache.druid.common.guava.SettableSupplier;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.BitmapResultFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.hive.druid.org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.hive.druid.org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.org.apache.druid.query.filter.DimFilter;
import org.apache.hive.druid.org.apache.druid.query.filter.Filter;
import org.apache.hive.druid.org.apache.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.hive.druid.org.apache.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.Cursor;
import org.apache.hive.druid.org.apache.druid.segment.DimensionSelector;
import org.apache.hive.druid.org.apache.druid.segment.IndexBuilder;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.VirtualColumns;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.filter.Filters;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorCursor;
import org.apache.hive.druid.org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public abstract class BaseFilterTest
extends InitializedNullHandlingTest {
    static final VirtualColumns VIRTUAL_COLUMNS = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "1.0 + 0.1", ValueType.FLOAT, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("exprDouble", "1.0 + 1.1", ValueType.DOUBLE, TestExprMacroTable.INSTANCE), (Object)new ExpressionVirtualColumn("exprLong", "1 + 2", ValueType.LONG, TestExprMacroTable.INSTANCE)));
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final List<InputRow> rows;
    protected final IndexBuilder indexBuilder;
    protected final Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher;
    protected final boolean cnf;
    protected final boolean optimize;
    protected final String testName;
    protected StorageAdapter adapter;
    private static ThreadLocal<Map<String, Map<String, Pair<StorageAdapter, Closeable>>>> adapterCache = ThreadLocal.withInitial(HashMap::new);

    public BaseFilterTest(String testName, List<InputRow> rows, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        this.testName = testName;
        this.rows = rows;
        this.indexBuilder = indexBuilder;
        this.finisher = finisher;
        this.cnf = cnf;
        this.optimize = optimize;
    }

    @Before
    public void setUp() throws Exception {
        Pair pair;
        String className = this.getClass().getName();
        Map<String, Pair<StorageAdapter, Closeable>> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass == null) {
            adaptersForClass = new HashMap<String, Pair<StorageAdapter, Closeable>>();
            adapterCache.get().put(className, adaptersForClass);
        }
        if ((pair = adaptersForClass.get(this.testName)) == null) {
            pair = (Pair)this.finisher.apply((Object)this.indexBuilder.tmpDir(this.temporaryFolder.newFolder()).rows(this.rows));
            adaptersForClass.put(this.testName, (Pair<StorageAdapter, Closeable>)pair);
        }
        this.adapter = (StorageAdapter)pair.lhs;
    }

    public static void tearDown(String className) throws Exception {
        Map<String, Pair<StorageAdapter, Closeable>> adaptersForClass = adapterCache.get().get(className);
        if (adaptersForClass != null) {
            for (Map.Entry<String, Pair<StorageAdapter, Closeable>> entry : adaptersForClass.entrySet()) {
                Closeable closeable = (Closeable)entry.getValue().rhs;
                closeable.close();
            }
            adapterCache.get().put(className, null);
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return BaseFilterTest.makeConstructors();
    }

    public static Collection<Object[]> makeConstructors() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        ImmutableMap bitmapSerdeFactories = ImmutableMap.of((Object)"concise", (Object)new ConciseBitmapSerdeFactory(), (Object)"roaring", (Object)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)));
        ImmutableMap segmentWriteOutMediumFactories = ImmutableMap.of((Object)"tmpFile segment write-out medium", (Object)TmpFileSegmentWriteOutMediumFactory.instance(), (Object)"off-heap memory segment write-out medium", (Object)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        ImmutableMap finishers = ImmutableMap.of((Object)"incremental", input -> {
            IncrementalIndex index = input.buildIncrementalIndex();
            return Pair.of((Object)new IncrementalIndexStorageAdapter(index), (Object)index);
        }, (Object)"mmapped", input -> {
            QueryableIndex index = input.buildMMappedIndex();
            return Pair.of((Object)new QueryableIndexStorageAdapter(index), (Object)index);
        }, (Object)"mmappedMerged", input -> {
            QueryableIndex index = input.buildMMappedMergedIndex();
            return Pair.of((Object)new QueryableIndexStorageAdapter(index), (Object)index);
        });
        for (Map.Entry bitmapSerdeFactoryEntry : bitmapSerdeFactories.entrySet()) {
            for (Map.Entry segmentWriteOutMediumFactoryEntry : segmentWriteOutMediumFactories.entrySet()) {
                for (Map.Entry finisherEntry : finishers.entrySet()) {
                    UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
                    while (unmodifiableIterator.hasNext()) {
                        boolean cnf = (Boolean)unmodifiableIterator.next();
                        UnmodifiableIterator unmodifiableIterator2 = ImmutableList.of((Object)false, (Object)true).iterator();
                        while (unmodifiableIterator2.hasNext()) {
                            boolean optimize = (Boolean)unmodifiableIterator2.next();
                            String testName = StringUtils.format((String)"bitmaps[%s], indexMerger[%s], finisher[%s], cnf[%s], optimize[%s]", (Object[])new Object[]{bitmapSerdeFactoryEntry.getKey(), segmentWriteOutMediumFactoryEntry.getKey(), finisherEntry.getKey(), cnf, optimize});
                            IndexBuilder indexBuilder = IndexBuilder.create().indexSpec(new IndexSpec((BitmapSerdeFactory)bitmapSerdeFactoryEntry.getValue(), null, null, null)).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)segmentWriteOutMediumFactoryEntry.getValue());
                            constructors.add(new Object[]{testName, indexBuilder, finisherEntry.getValue(), cnf, optimize});
                        }
                    }
                }
            }
        }
        return constructors;
    }

    private Filter makeFilter(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        DimFilter maybeOptimized = this.optimize ? dimFilter.optimize() : dimFilter;
        Filter filter = maybeOptimized.toFilter();
        return this.cnf ? Filters.convertToCNF((Filter)filter) : filter;
    }

    private DimFilter maybeOptimize(DimFilter dimFilter) {
        if (dimFilter == null) {
            return null;
        }
        return this.optimize ? dimFilter.optimize() : dimFilter;
    }

    private Sequence<Cursor> makeCursorSequence(Filter filter) {
        return this.adapter.makeCursors(filter, Intervals.ETERNITY, VIRTUAL_COLUMNS, Granularities.ALL, false, null);
    }

    private VectorCursor makeVectorCursor(Filter filter) {
        return this.adapter.makeVectorCursor(filter, Intervals.ETERNITY, VirtualColumns.EMPTY, false, 3, null);
    }

    private List<String> selectColumnValuesMatchingFilter(DimFilter filter, String selectColumn) {
        Sequence<Cursor> cursors = this.makeCursorSequence(this.makeFilter(filter));
        Sequence seq = Sequences.map(cursors, cursor -> {
            DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                IndexedInts row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                values.add(selector.lookupName(row.get(0)));
                cursor.advance();
            }
            return values;
        });
        return (List)seq.toList().get(0);
    }

    private long selectCountUsingFilteredAggregator(DimFilter filter) {
        Sequence<Cursor> cursors = this.makeCursorSequence(null);
        Sequence aggSeq = Sequences.map(cursors, cursor -> {
            Aggregator agg = new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count"), this.maybeOptimize(filter)).factorize(cursor.getColumnSelectorFactory());
            while (!cursor.isDone()) {
                agg.aggregate();
                cursor.advance();
            }
            return agg;
        });
        return ((Aggregator)aggSeq.toList().get(0)).getLong();
    }

    private long selectCountUsingVectorizedFilteredAggregator(DimFilter dimFilter) {
        Preconditions.checkState((boolean)this.makeFilter(dimFilter).canVectorizeMatcher(), (String)"Cannot vectorize filter: %s", (Object[])new Object[]{dimFilter});
        try (VectorCursor cursor = this.makeVectorCursor(null);){
            long val2;
            FilteredAggregatorFactory aggregatorFactory = new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("count"), this.maybeOptimize(dimFilter));
            VectorAggregator aggregator = aggregatorFactory.factorizeVector(cursor.getColumnSelectorFactory());
            ByteBuffer buf = ByteBuffer.allocate(aggregatorFactory.getMaxIntermediateSizeWithNulls() * 2);
            aggregator.init(buf, 0);
            aggregator.init(buf, aggregatorFactory.getMaxIntermediateSizeWithNulls());
            while (!cursor.isDone()) {
                aggregator.aggregate(buf, 0, 0, cursor.getCurrentVectorSize());
                int[] positions = new int[cursor.getCurrentVectorSize()];
                Arrays.fill(positions, aggregatorFactory.getMaxIntermediateSizeWithNulls());
                int[] allRows = new int[cursor.getCurrentVectorSize()];
                for (int i = 0; i < allRows.length; ++i) {
                    allRows[i] = i;
                }
                aggregator.aggregate(buf, cursor.getCurrentVectorSize(), positions, allRows, 0);
                cursor.advance();
            }
            long val1 = (Long)aggregator.get(buf, 0);
            if (val1 != (val2 = ((Long)aggregator.get(buf, aggregatorFactory.getMaxIntermediateSizeWithNulls())).longValue())) {
                throw new ISE("Oh no, val1[%d] != val2[%d]", new Object[]{val1, val2});
            }
            long l = val1;
            return l;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingPostFiltering(DimFilter filter, String selectColumn) {
        final Filter theFilter = this.makeFilter(filter);
        Filter postFilteringFilter = new Filter(){

            public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
                throw new UnsupportedOperationException();
            }

            public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
                return theFilter.makeMatcher(factory);
            }

            public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
                return false;
            }

            public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
                return false;
            }

            public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
                return false;
            }

            public Set<String> getRequiredColumns() {
                return Collections.emptySet();
            }

            public double estimateSelectivity(BitmapIndexSelector indexSelector) {
                return 1.0;
            }
        };
        Sequence<Cursor> cursors = this.makeCursorSequence(postFilteringFilter);
        Sequence seq = Sequences.map(cursors, cursor -> {
            DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                IndexedInts row = selector.getRow();
                Preconditions.checkState((row.size() == 1 ? 1 : 0) != 0);
                values.add(selector.lookupName(row.get(0)));
                cursor.advance();
            }
            return values;
        });
        return (List)seq.toList().get(0);
    }

    private List<String> selectColumnValuesMatchingFilterUsingVectorizedPostFiltering(DimFilter filter, String selectColumn) {
        final Filter theFilter = this.makeFilter(filter);
        Filter postFilteringFilter = new Filter(){

            public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
                throw new UnsupportedOperationException();
            }

            public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
                return theFilter.makeMatcher(factory);
            }

            public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
                return false;
            }

            public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
                return false;
            }

            public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
                return theFilter.makeVectorMatcher(factory);
            }

            public boolean canVectorizeMatcher() {
                return theFilter.canVectorizeMatcher();
            }

            public Set<String> getRequiredColumns() {
                return null;
            }

            public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
                return false;
            }

            public double estimateSelectivity(BitmapIndexSelector indexSelector) {
                return 1.0;
            }
        };
        try (VectorCursor cursor = this.makeVectorCursor(postFilteringFilter);){
            SingleValueDimensionVectorSelector selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                int[] rowVector = selector.getRowVector();
                for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                    values.add(selector.lookupName(rowVector[i]));
                }
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingVectorCursor(DimFilter filter, String selectColumn) {
        try (VectorCursor cursor = this.makeVectorCursor(this.makeFilter(filter));){
            SingleValueDimensionVectorSelector selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)new DefaultDimensionSpec(selectColumn, selectColumn));
            ArrayList<String> values = new ArrayList<String>();
            while (!cursor.isDone()) {
                int[] rowVector = selector.getRowVector();
                for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                    values.add(selector.lookupName(rowVector[i]));
                }
                cursor.advance();
            }
            ArrayList<String> arrayList = values;
            return arrayList;
        }
    }

    private List<String> selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(DimFilter filter, String selectColumn) {
        HashMap<String, ValueType> rowSignature = new HashMap<String, ValueType>();
        for (String columnName : Iterables.concat((Iterable)this.adapter.getAvailableDimensions(), (Iterable)this.adapter.getAvailableMetrics())) {
            rowSignature.put(columnName, this.adapter.getColumnCapabilities(columnName).getType());
        }
        SettableSupplier rowSupplier = new SettableSupplier();
        ValueMatcher matcher = this.makeFilter(filter).makeMatcher(VIRTUAL_COLUMNS.wrap((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create(() -> ((SettableSupplier)rowSupplier).get(), rowSignature)));
        ArrayList<String> values = new ArrayList<String>();
        for (InputRow row : this.rows) {
            rowSupplier.set((Object)row);
            if (!matcher.matches()) continue;
            values.add((String)row.getRaw(selectColumn));
        }
        return values;
    }

    protected void assertFilterMatches(DimFilter filter, List<String> expectedRows) {
        boolean testVectorized = !(this.adapter instanceof IncrementalIndexStorageAdapter);
        this.assertFilterMatches(filter, expectedRows, testVectorized);
    }

    protected void assertFilterMatchesSkipVectorize(DimFilter filter, List<String> expectedRows) {
        this.assertFilterMatches(filter, expectedRows, false);
    }

    private void assertFilterMatches(DimFilter filter, List<String> expectedRows, boolean testVectorized) {
        Assert.assertEquals((String)("Cursor: " + filter), expectedRows, this.selectColumnValuesMatchingFilter(filter, "dim0"));
        if (testVectorized) {
            Assert.assertEquals((String)("Cursor (vectorized): " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingVectorCursor(filter, "dim0"));
        }
        Assert.assertEquals((String)("Cursor with postFiltering: " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingPostFiltering(filter, "dim0"));
        if (testVectorized) {
            Assert.assertEquals((String)("Cursor with postFiltering (vectorized): " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingVectorizedPostFiltering(filter, "dim0"));
        }
        Assert.assertEquals((String)("Filtered aggregator: " + filter), (long)expectedRows.size(), (long)this.selectCountUsingFilteredAggregator(filter));
        if (testVectorized) {
            Assert.assertEquals((String)("Filtered aggregator (vectorized): " + filter), (long)expectedRows.size(), (long)this.selectCountUsingVectorizedFilteredAggregator(filter));
        }
        Assert.assertEquals((String)("RowBasedColumnSelectorFactory: " + filter), expectedRows, this.selectColumnValuesMatchingFilterUsingRowBasedColumnSelectorFactory(filter, "dim0"));
    }
}

