/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.hive.druid.org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.junit.Assert;
import org.junit.Test;

public class VSizeColumnarMultiIntsTest {
    @Test
    public void testSanity() throws Exception {
        List<int[]> someInts = Arrays.asList({1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        VSizeColumnarMultiInts indexed = VSizeColumnarMultiInts.fromIterable((Iterable)Iterables.transform(someInts, (Function)new Function<int[], VSizeColumnarInts>(){

            public VSizeColumnarInts apply(int[] input) {
                return VSizeColumnarInts.fromArray((int[])input, (int)20);
            }
        }));
        this.assertSame(someInts, indexed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        indexed.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)indexed.getSerializedSize(), (long)bytes.length);
        VSizeColumnarMultiInts deserializedIndexed = VSizeColumnarMultiInts.readFromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes));
        this.assertSame(someInts, deserializedIndexed);
    }

    private void assertSame(List<int[]> someInts, VSizeColumnarMultiInts indexed) {
        Assert.assertEquals((long)3L, (long)indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            int[] ints = someInts.get(i);
            VSizeColumnarInts vSizeColumnarInts = indexed.get(i);
            Assert.assertEquals((long)ints.length, (long)vSizeColumnarInts.size());
            Assert.assertEquals((long)1L, (long)vSizeColumnarInts.getNumBytes());
            for (int j = 0; j < ints.length; ++j) {
                Assert.assertEquals((long)ints[j], (long)vSizeColumnarInts.get(j));
            }
        }
    }
}

