/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.hive.druid.org.apache.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VSizeColumnarIntsSerializerTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private final SegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
    private final Random rand = new Random(0L);
    private int[] vals;

    @Before
    public void setUp() {
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        this.segmentWriteOutMedium.close();
    }

    private void generateVals(int totalSize, int maxValue) {
        this.vals = new int[totalSize];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = this.rand.nextInt(maxValue);
        }
    }

    private void checkSerializedSizeAndData() throws Exception {
        int maxValue = this.vals.length == 0 ? 0 : Ints.max((int[])this.vals);
        VSizeColumnarIntsSerializer writer = new VSizeColumnarIntsSerializer(this.segmentWriteOutMedium, maxValue);
        VSizeColumnarInts intsFromList = VSizeColumnarInts.fromIndexedInts((IndexedInts)new ArrayBasedIndexedInts(this.vals), (int)maxValue);
        writer.open();
        for (int val : this.vals) {
            writer.addValue(val);
        }
        long writtenLength = writer.getSerializedSize();
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writer.writeTo((WritableByteChannel)writeOutBytes, null);
        Assert.assertEquals((long)writtenLength, (long)intsFromList.getSerializedSize());
        VSizeColumnarInts intsFromByteBuffer = VSizeColumnarInts.readFromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())));
        Assert.assertEquals((long)this.vals.length, (long)intsFromByteBuffer.size());
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)intsFromByteBuffer.get(i));
        }
    }

    @Test
    public void testAdd() throws Exception {
        for (int maxValue : MAX_VALUES) {
            this.generateVals(this.rand.nextInt(100) + 10, maxValue);
            this.checkSerializedSizeAndData();
        }
    }

    @Test
    public void testWriteEmpty() throws Exception {
        this.vals = new int[0];
        this.checkSerializedSizeAndData();
    }
}

