/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedColumnarIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.org.apache.druid.segment.data.IndexedInts;
import org.apache.hive.druid.org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class V3CompressedVSizeColumnarMultiIntsSerializerTest {
    private static final int[] OFFSET_CHUNK_FACTORS = new int[]{1, 2, 100, 16384};
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private final CompressionStrategy compressionStrategy;
    private final ByteOrder byteOrder;
    private final Random rand = new Random(0L);
    private List<int[]> vals;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public V3CompressedVSizeColumnarMultiIntsSerializerTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        this.compressionStrategy = compressionStrategy;
        this.byteOrder = byteOrder;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategiesAndByteOrders() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateVals(int totalSize, int maxValue) {
        this.vals = new ArrayList<int[]>(totalSize);
        for (int i = 0; i < totalSize; ++i) {
            int len = this.rand.nextInt(2) + 1;
            int[] subVals = new int[len];
            for (int j = 0; j < len; ++j) {
                subVals[j] = this.rand.nextInt(maxValue);
            }
            this.vals.add(subVals);
        }
    }

    private void checkSerializedSizeAndData(int offsetChunkFactor, int valueChunkFactor) throws Exception {
        FileSmoosher smoosher = new FileSmoosher(this.temporaryFolder.newFolder());
        try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();){
            int maxValue = this.vals.size() > 0 ? this.getMaxValue(this.vals) : 0;
            CompressedColumnarIntsSerializer offsetWriter = new CompressedColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, "offset", offsetChunkFactor, this.byteOrder, this.compressionStrategy);
            CompressedVSizeColumnarIntsSerializer valueWriter = new CompressedVSizeColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, "value", maxValue, valueChunkFactor, this.byteOrder, this.compressionStrategy);
            V3CompressedVSizeColumnarMultiIntsSerializer writer = new V3CompressedVSizeColumnarMultiIntsSerializer(offsetWriter, valueWriter);
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromIterable = V3CompressedVSizeColumnarMultiIntsSupplier.fromIterable((Iterable)Iterables.transform(this.vals, ArrayBasedIndexedInts::new), (int)offsetChunkFactor, (int)maxValue, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)segmentWriteOutMedium.getCloser());
            writer.open();
            for (int[] val : this.vals) {
                writer.addValues((IndexedInts)new ArrayBasedIndexedInts(val));
            }
            long writtenLength = writer.getSerializedSize();
            WriteOutBytes writeOutBytes = segmentWriteOutMedium.makeWriteOutBytes();
            writer.writeTo((WritableByteChannel)writeOutBytes, smoosher);
            smoosher.close();
            Assert.assertEquals((long)writtenLength, (long)supplierFromIterable.getSerializedSize());
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromByteBuffer = V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())), (ByteOrder)this.byteOrder);
            try (ColumnarMultiInts columnarMultiInts = supplierFromByteBuffer.get();){
                Assert.assertEquals((long)columnarMultiInts.size(), (long)this.vals.size());
                for (int i = 0; i < this.vals.size(); ++i) {
                    IndexedInts subVals = columnarMultiInts.get(i);
                    Assert.assertEquals((long)subVals.size(), (long)this.vals.get(i).length);
                    int size = subVals.size();
                    for (int j = 0; j < size; ++j) {
                        Assert.assertEquals((long)subVals.get(j), (long)this.vals.get(i)[j]);
                    }
                }
            }
        }
    }

    private int getMaxValue(List<int[]> vals) {
        return vals.stream().mapToInt(array -> IntStream.of(array).max().orElse(0)).max().orElseThrow(NoSuchElementException::new);
    }

    @Before
    public void setUp() {
        this.vals = null;
    }

    @Test
    public void testSmallData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals(this.rand.nextInt(valueChunk), maxValue);
                this.checkSerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }

    @Test
    public void testLargeData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals((this.rand.nextInt(2) + 1) * valueChunk + this.rand.nextInt(valueChunk), maxValue);
                this.checkSerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }

    @Test
    public void testEmpty() throws Exception {
        this.vals = new ArrayList<int[]>();
        this.checkSerializedSizeAndData(1, 2);
    }

    private void checkV2SerializedSizeAndData(int offsetChunkFactor, int valueChunkFactor) throws Exception {
        File tmpDirectory = FileUtils.createTempDir((String)StringUtils.format((String)"CompressedVSizeIndexedV3WriterTest_%d_%d", (Object[])new Object[]{offsetChunkFactor, offsetChunkFactor}));
        FileSmoosher smoosher = new FileSmoosher(tmpDirectory);
        int maxValue = this.vals.size() > 0 ? this.getMaxValue(this.vals) : 0;
        try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();){
            CompressedColumnarIntsSerializer offsetWriter = new CompressedColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, offsetChunkFactor, this.byteOrder, this.compressionStrategy, GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"offset", (CompressionStrategy)this.compressionStrategy, (int)2000000));
            GenericIndexedWriter genericIndexed = GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"value", (CompressionStrategy)this.compressionStrategy, (int)2000000);
            CompressedVSizeColumnarIntsSerializer valueWriter = new CompressedVSizeColumnarIntsSerializer((SegmentWriteOutMedium)segmentWriteOutMedium, maxValue, valueChunkFactor, this.byteOrder, this.compressionStrategy, genericIndexed);
            V3CompressedVSizeColumnarMultiIntsSerializer writer = new V3CompressedVSizeColumnarMultiIntsSerializer(offsetWriter, valueWriter);
            writer.open();
            for (int[] val : this.vals) {
                writer.addValues((IndexedInts)new ArrayBasedIndexedInts(val));
            }
            SmooshedWriter channel = smoosher.addWithSmooshedWriter("test", writer.getSerializedSize());
            writer.writeTo((WritableByteChannel)channel, smoosher);
            channel.close();
            smoosher.close();
            SmooshedFileMapper mapper = Smoosh.map((File)tmpDirectory);
            V3CompressedVSizeColumnarMultiIntsSupplier supplierFromByteBuffer = V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)mapper.mapFile("test"), (ByteOrder)this.byteOrder);
            ColumnarMultiInts columnarMultiInts = supplierFromByteBuffer.get();
            Assert.assertEquals((long)columnarMultiInts.size(), (long)this.vals.size());
            for (int i = 0; i < this.vals.size(); ++i) {
                IndexedInts subVals = columnarMultiInts.get(i);
                Assert.assertEquals((long)subVals.size(), (long)this.vals.get(i).length);
                int size = subVals.size();
                for (int j = 0; j < size; ++j) {
                    Assert.assertEquals((long)subVals.get(j), (long)this.vals.get(i)[j]);
                }
            }
            CloseQuietly.close((Closeable)columnarMultiInts);
            mapper.close();
        }
    }

    @Test
    public void testMultiValueFileLargeData() throws Exception {
        for (int offsetChunk : OFFSET_CHUNK_FACTORS) {
            for (int maxValue : MAX_VALUES) {
                int valueChunk = CompressedVSizeColumnarIntsSupplier.maxIntsInBufferForValue((int)maxValue);
                this.generateVals((this.rand.nextInt(2) + 1) * valueChunk + this.rand.nextInt(valueChunk), maxValue);
                this.checkV2SerializedSizeAndData(offsetChunk, valueChunk);
            }
        }
    }
}

