/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.hive.druid.org.apache.druid.segment.column.DoublesColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.FloatsColumn;
import org.apache.hive.druid.org.apache.druid.segment.column.LongsColumn;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarFloats;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarLongs;
import org.apache.hive.druid.org.apache.druid.segment.data.ReadableOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorOffset;
import org.apache.hive.druid.org.apache.druid.segment.vector.VectorValueSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericNullColumnSelectorTest {
    private final int seed = 1337;
    private final Random rando = new Random(1337L);
    private final int numBitmaps = 32;
    private final int numRows = 1024;
    private final int vectorSize = 128;
    private final SimpleAscendingOffset offset = new SimpleAscendingOffset(1024);
    private final NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(128, 0, 1024);
    private final NoFilterOffsetThatCanBeMangledToTestOverlapping anotherVectorOffset = new NoFilterOffsetThatCanBeMangledToTestOverlapping(128, 0, 1024);
    private ImmutableBitmap[] bitmaps;

    @Before
    public void setup() {
        this.bitmaps = new ImmutableBitmap[32];
        for (int bitmap = 0; bitmap < 32; ++bitmap) {
            WrappedRoaringBitmap mutable = new WrappedRoaringBitmap();
            for (int i = 0; i < 1024; ++i) {
                if (!(this.rando.nextDouble() > 0.2)) continue;
                mutable.add(i);
            }
            this.bitmaps[bitmap] = mutable.toImmutableBitmap();
        }
    }

    @Test
    public void testLongSelectorWithNullsCanResetOffset() {
        for (ImmutableBitmap bitmap : this.bitmaps) {
            ColumnarLongs longs = new ColumnarLongs(){

                public int size() {
                    return 1024;
                }

                public long get(int index) {
                    return ThreadLocalRandom.current().nextLong();
                }

                public void close() {
                }
            };
            LongsColumn columnWithNulls = LongsColumn.create((ColumnarLongs)longs, (ImmutableBitmap)bitmap);
            ColumnValueSelector selector = columnWithNulls.makeColumnValueSelector((ReadableOffset)this.offset);
            NumericNullColumnSelectorTest.assertOffsetCanReset((BaseNullableColumnValueSelector)selector, bitmap, this.offset);
            VectorValueSelector vectorSelector = columnWithNulls.makeVectorValueSelector((ReadableVectorOffset)this.vectorOffset);
            NumericNullColumnSelectorTest.assertVectorOffsetCanReset(vectorSelector, bitmap, this.vectorOffset);
        }
    }

    @Test
    public void testFloatSelectorWithNullsCanResetOffset() {
        for (ImmutableBitmap bitmap : this.bitmaps) {
            ColumnarFloats floats = new ColumnarFloats(){

                public int size() {
                    return 1024;
                }

                public float get(int index) {
                    return ThreadLocalRandom.current().nextFloat();
                }

                public void close() {
                }
            };
            FloatsColumn columnWithNulls = FloatsColumn.create((ColumnarFloats)floats, (ImmutableBitmap)bitmap);
            ColumnValueSelector selector = columnWithNulls.makeColumnValueSelector((ReadableOffset)this.offset);
            NumericNullColumnSelectorTest.assertOffsetCanReset((BaseNullableColumnValueSelector)selector, bitmap, this.offset);
            VectorValueSelector vectorSelector = columnWithNulls.makeVectorValueSelector((ReadableVectorOffset)this.vectorOffset);
            NumericNullColumnSelectorTest.assertVectorOffsetCanReset(vectorSelector, bitmap, this.vectorOffset);
            VectorValueSelector anotherSelector = columnWithNulls.makeVectorValueSelector((ReadableVectorOffset)this.anotherVectorOffset);
            NumericNullColumnSelectorTest.assertVectorChillWhenOffsetsOverlap(anotherSelector, bitmap, this.anotherVectorOffset);
        }
    }

    @Test
    public void testDoubleSelectorWithNullsCanResetOffset() {
        for (ImmutableBitmap bitmap : this.bitmaps) {
            ColumnarDoubles doubles = new ColumnarDoubles(){

                public int size() {
                    return 1024;
                }

                public double get(int index) {
                    return ThreadLocalRandom.current().nextDouble();
                }

                public void close() {
                }
            };
            DoublesColumn columnWithNulls = DoublesColumn.create((ColumnarDoubles)doubles, (ImmutableBitmap)bitmap);
            ColumnValueSelector selector = columnWithNulls.makeColumnValueSelector((ReadableOffset)this.offset);
            NumericNullColumnSelectorTest.assertOffsetCanReset((BaseNullableColumnValueSelector)selector, bitmap, this.offset);
            VectorValueSelector vectorSelector = columnWithNulls.makeVectorValueSelector((ReadableVectorOffset)this.vectorOffset);
            NumericNullColumnSelectorTest.assertVectorOffsetCanReset(vectorSelector, bitmap, this.vectorOffset);
        }
    }

    private static void assertOffsetCanReset(BaseNullableColumnValueSelector selector, ImmutableBitmap bitmap, SimpleAscendingOffset readItAll) {
        boolean encounteredNull = false;
        while (readItAll.withinBounds()) {
            Assert.assertEquals((Object)bitmap.get(readItAll.getOffset()), (Object)selector.isNull());
            encounteredNull |= selector.isNull();
            readItAll.increment();
        }
        readItAll.reset();
        Assert.assertTrue((boolean)encounteredNull);
        encounteredNull = false;
        while (readItAll.withinBounds()) {
            Assert.assertEquals((Object)bitmap.get(readItAll.getOffset()), (Object)selector.isNull());
            encounteredNull |= selector.isNull();
            readItAll.increment();
        }
        Assert.assertTrue((boolean)encounteredNull);
        readItAll.reset();
    }

    private static void assertVectorOffsetCanReset(VectorValueSelector selector, ImmutableBitmap bitmap, NoFilterVectorOffset readAllVectors) {
        int i;
        boolean[] nullVector;
        boolean encounteredNull = false;
        while (!readAllVectors.isDone()) {
            nullVector = selector.getNullVector();
            for (i = readAllVectors.getStartOffset(); i < readAllVectors.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((Object)bitmap.get(readAllVectors.getStartOffset() + i), (Object)nullVector[i]);
                encounteredNull |= nullVector[i];
            }
            readAllVectors.advance();
        }
        readAllVectors.reset();
        Assert.assertTrue((boolean)encounteredNull);
        encounteredNull = false;
        while (!readAllVectors.isDone()) {
            nullVector = selector.getNullVector();
            for (i = readAllVectors.getStartOffset(); i < readAllVectors.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((Object)bitmap.get(readAllVectors.getStartOffset() + i), (Object)nullVector[i]);
                encounteredNull |= nullVector[i];
            }
            readAllVectors.advance();
        }
        Assert.assertTrue((boolean)encounteredNull);
        readAllVectors.reset();
    }

    public static void assertVectorChillWhenOffsetsOverlap(VectorValueSelector selector, ImmutableBitmap bitmap, NoFilterOffsetThatCanBeMangledToTestOverlapping readAllVectors) {
        int i;
        boolean encounteredNull = false;
        readAllVectors.mangleOffset(0);
        boolean[] nullVector = selector.getNullVector();
        for (i = readAllVectors.getStartOffset(); i < readAllVectors.getCurrentVectorSize(); ++i) {
            Assert.assertEquals((Object)bitmap.get(readAllVectors.getStartOffset() + i), (Object)nullVector[i]);
            encounteredNull |= nullVector[i];
        }
        Assert.assertTrue((boolean)encounteredNull);
        readAllVectors.mangleOffset(1);
        nullVector = selector.getNullVector();
        for (i = readAllVectors.getStartOffset(); i < readAllVectors.getCurrentVectorSize(); ++i) {
            Assert.assertEquals((Object)bitmap.get(readAllVectors.getStartOffset() + i), (Object)nullVector[i]);
            encounteredNull |= nullVector[i];
        }
        readAllVectors.reset();
        Assert.assertTrue((boolean)encounteredNull);
    }

    private static class NoFilterOffsetThatCanBeMangledToTestOverlapping
    implements VectorOffset {
        private final int maxVectorSize;
        private final int start;
        private final int end;
        private int theOffset;

        NoFilterOffsetThatCanBeMangledToTestOverlapping(int maxVectorSize, int start, int end) {
            this.maxVectorSize = maxVectorSize;
            this.start = start;
            this.end = end;
            this.reset();
        }

        public void mangleOffset(int replacement) {
            this.theOffset = replacement;
        }

        public int getId() {
            return this.theOffset;
        }

        public void advance() {
            this.theOffset += this.maxVectorSize;
        }

        public boolean isDone() {
            return this.theOffset >= this.end;
        }

        public boolean isContiguous() {
            return true;
        }

        public int getMaxVectorSize() {
            return this.maxVectorSize;
        }

        public int getCurrentVectorSize() {
            return Math.min(this.maxVectorSize, this.end - this.theOffset);
        }

        public int getStartOffset() {
            return this.theOffset;
        }

        public int[] getOffsets() {
            throw new UnsupportedOperationException("no filter");
        }

        public void reset() {
            this.theOffset = this.start;
        }
    }
}

