/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.Closer;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.org.apache.druid.segment.data.ColumnarInts;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedColumnarIntsSerializer;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressedColumnarIntsSupplier;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.org.apache.druid.segment.writeout.WriteOutBytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedColumnarIntsSerializerTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private static final int[] CHUNK_FACTORS = new int[]{1, 2, 100, 16384};
    private final SegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
    private final CompressionStrategy compressionStrategy;
    private final ByteOrder byteOrder;
    private final Random rand = new Random(0L);
    private int[] vals;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public CompressedColumnarIntsSerializerTest(CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        this.compressionStrategy = compressionStrategy;
        this.byteOrder = byteOrder;
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategiesAndByteOrders() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Before
    public void setUp() {
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        this.segmentWriteOutMedium.close();
    }

    private void generateVals(int totalSize, int maxValue) {
        this.vals = new int[totalSize];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = this.rand.nextInt(maxValue);
        }
    }

    private void checkSerializedSizeAndData(int chunkFactor) throws Exception {
        FileSmoosher smoosher = new FileSmoosher(this.temporaryFolder.newFolder());
        CompressedColumnarIntsSerializer writer = new CompressedColumnarIntsSerializer(this.segmentWriteOutMedium, "test", chunkFactor, this.byteOrder, this.compressionStrategy);
        CompressedColumnarIntsSupplier supplierFromList = CompressedColumnarIntsSupplier.fromList((IntArrayList)IntArrayList.wrap((int[])this.vals), (int)chunkFactor, (ByteOrder)this.byteOrder, (CompressionStrategy)this.compressionStrategy, (Closer)this.segmentWriteOutMedium.getCloser());
        writer.open();
        for (int val : this.vals) {
            writer.addValue(val);
        }
        long writtenLength = writer.getSerializedSize();
        WriteOutBytes writeOutBytes = this.segmentWriteOutMedium.makeWriteOutBytes();
        writer.writeTo((WritableByteChannel)writeOutBytes, smoosher);
        smoosher.close();
        Assert.assertEquals((long)writtenLength, (long)supplierFromList.getSerializedSize());
        CompressedColumnarIntsSupplier supplierFromByteBuffer = CompressedColumnarIntsSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(IOUtils.toByteArray((InputStream)writeOutBytes.asInputStream())), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        Assert.assertEquals((long)this.vals.length, (long)columnarInts.size());
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseQuietly.close((Closeable)columnarInts);
    }

    @Test
    public void testSmallData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            for (int chunkFactor : CHUNK_FACTORS) {
                this.generateVals(this.rand.nextInt(chunkFactor), maxValue);
                this.checkSerializedSizeAndData(chunkFactor);
            }
        }
    }

    @Test
    public void testLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            for (int chunkFactor : CHUNK_FACTORS) {
                this.generateVals((this.rand.nextInt(5) + 5) * chunkFactor + this.rand.nextInt(chunkFactor), maxValue);
                this.checkSerializedSizeAndData(chunkFactor);
            }
        }
    }

    @Test
    public void testWriteEmpty() throws Exception {
        this.vals = new int[0];
        this.checkSerializedSizeAndData(2);
    }

    private void checkV2SerializedSizeAndData(int chunkFactor) throws Exception {
        File tmpDirectory = FileUtils.createTempDir((String)StringUtils.format((String)"CompressedIntsIndexedWriterTest_%d", (Object[])new Object[]{chunkFactor}));
        FileSmoosher smoosher = new FileSmoosher(tmpDirectory);
        CompressedColumnarIntsSerializer writer = new CompressedColumnarIntsSerializer(this.segmentWriteOutMedium, chunkFactor, this.byteOrder, this.compressionStrategy, GenericIndexedWriter.ofCompressedByteBuffers((SegmentWriteOutMedium)this.segmentWriteOutMedium, (String)"test", (CompressionStrategy)this.compressionStrategy, (int)80000));
        writer.open();
        for (int val : this.vals) {
            writer.addValue(val);
        }
        SmooshedWriter channel = smoosher.addWithSmooshedWriter("test", writer.getSerializedSize());
        writer.writeTo((WritableByteChannel)channel, smoosher);
        channel.close();
        smoosher.close();
        SmooshedFileMapper mapper = Smoosh.map((File)tmpDirectory);
        CompressedColumnarIntsSupplier supplierFromByteBuffer = CompressedColumnarIntsSupplier.fromByteBuffer((ByteBuffer)mapper.mapFile("test"), (ByteOrder)this.byteOrder);
        ColumnarInts columnarInts = supplierFromByteBuffer.get();
        Assert.assertEquals((long)this.vals.length, (long)columnarInts.size());
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)this.vals[i], (long)columnarInts.get(i));
        }
        CloseQuietly.close((Closeable)columnarInts);
        mapper.close();
    }

    @Test
    public void testMultiValueFileLargeData() throws Exception {
        for (int maxValue : MAX_VALUES) {
            for (int chunkFactor : CHUNK_FACTORS) {
                this.generateVals((this.rand.nextInt(5) + 5) * chunkFactor + this.rand.nextInt(chunkFactor), maxValue);
                this.checkV2SerializedSizeAndData(chunkFactor);
            }
        }
    }
}

