/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment.column;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class ColumnCapabilitiesImplTest {
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String json = this.mapper.writeValueAsString((Object)new ColumnCapabilitiesImpl().setDictionaryEncoded(true).setHasBitmapIndexes(true).setHasMultipleValues(true).setHasSpatialIndexes(true).setType(ValueType.COMPLEX).setFilterable(true));
        Assert.assertFalse((boolean)json.contains("filterable"));
        ColumnCapabilities cc = (ColumnCapabilities)this.mapper.readValue(json, ColumnCapabilitiesImpl.class);
        Assert.assertEquals((Object)ValueType.COMPLEX, (Object)cc.getType());
        Assert.assertTrue((boolean)cc.isDictionaryEncoded());
        Assert.assertFalse((boolean)cc.isRunLengthEncoded());
        Assert.assertTrue((boolean)cc.hasSpatialIndexes());
        Assert.assertTrue((boolean)cc.hasMultipleValues());
        Assert.assertTrue((boolean)cc.hasBitmapIndexes());
        Assert.assertFalse((boolean)cc.isFilterable());
    }

    @Test
    public void testDeserialization() throws Exception {
        String json = "{\n  \"type\":\"COMPLEX\",\n  \"dictionaryEncoded\":true,\n  \"runLengthEncoded\":true,\n  \"hasSpatialIndexes\":true,\n  \"hasMultipleValues\":true,\n  \"hasBitmapIndexes\":true,\n  \"filterable\":true\n}";
        ColumnCapabilities cc = (ColumnCapabilities)this.mapper.readValue(json, ColumnCapabilitiesImpl.class);
        Assert.assertEquals((Object)ValueType.COMPLEX, (Object)cc.getType());
        Assert.assertTrue((boolean)cc.isDictionaryEncoded());
        Assert.assertTrue((boolean)cc.isRunLengthEncoded());
        Assert.assertTrue((boolean)cc.hasSpatialIndexes());
        Assert.assertTrue((boolean)cc.hasMultipleValues());
        Assert.assertTrue((boolean)cc.hasBitmapIndexes());
        Assert.assertFalse((boolean)cc.isFilterable());
    }
}

