/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.Pair;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.TestQueryRunners;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.org.apache.druid.query.search.SearchHit;
import org.apache.hive.druid.org.apache.druid.query.search.SearchQuery;
import org.apache.hive.druid.org.apache.druid.query.search.SearchResultValue;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQuery;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.org.apache.druid.segment.SchemalessIndexTest;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemalessTestFullTest {
    final double UNIQUES_2 = 2.000977198748901;
    final double UNIQUES_1 = 1.0002442201269182;
    final SchemalessIndexTest schemalessIndexTest;
    final String dataSource = "testing";
    final Granularity ALL_GRAN = Granularities.ALL;
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public SchemalessTestFullTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.schemalessIndexTest = new SchemalessIndexTest(segmentWriteOutMediumFactory);
    }

    @Test
    public void testCompleteIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")))));
        this.testAll(1, 5, expectedTimeSeriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testEmptyStrings() {
        List<Result<TimeseriesResultValue>> expectedTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.emptyList())));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.emptyList())));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.testAll(9, 10, expectedTimeSeriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testNonIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)103.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)(NullHandling.replaceWithDefault() ? 0.0 : 100.0)).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), QueryRunnerTestHelper.orderedMap("market", null, "rows", 1L, "index", 0.0, "addRowsIndexConstant", 2.0, "uniques", 0.0, "maxIndex", 0.0, "minIndex", 0.0)))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.singletonList(new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.testAll(2, 3, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testPartialIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("quality", "automotive"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.singletonList(new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")))));
        this.testAll(2, 4, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testSupersetSchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TopNResultValue>> expectedTopNResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults;
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.testAll(1, 2, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testValueAndEmptySchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)103.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)(NullHandling.replaceWithDefault() ? 0.0 : 100.0)).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), QueryRunnerTestHelper.orderedMap("market", null, "rows", 1L, "index", 0.0, "addRowsIndexConstant", 2.0, "uniques", 0.0, "maxIndex", 0.0, "minIndex", 0.0)))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.testAll(0, 1, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testEmptySchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue(TestHelper.createExpectedMap("rows", 1L, "index", NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null, "addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(2.0) : null, "uniques", 0.0, "maxIndex", NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null, "minIndex", NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null))));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue(TestHelper.createExpectedMap("rows", 0L, "index", NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null, "addRowsIndexConstant", NullHandling.replaceWithDefault() ? Double.valueOf(1.0) : null, "uniques", 0.0, "maxIndex", NullHandling.replaceWithDefault() ? Double.valueOf(Double.NEGATIVE_INFINITY) : null, "minIndex", NullHandling.replaceWithDefault() ? Double.valueOf(Double.POSITIVE_INFINITY) : null))));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(QueryRunnerTestHelper.orderedMap("market", null, "rows", 1L, "index", 0.0, "addRowsIndexConstant", 2.0, "uniques", 0.0, "maxIndex", 0.0, "minIndex", 0.0)))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.emptyList())));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.emptyList())));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(this.schemalessIndexTest.getMergedIncrementalIndex(0, 0), null), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[0, 0]");
    }

    @Test
    public void testExactSameSchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TopNResultValue>> expectedTopNResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults;
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)202.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)200.0).put((Object)"minIndex", (Object)200.0).build())));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)202.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)200.0).put((Object)"minIndex", (Object)200.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(this.schemalessIndexTest.getMergedIncrementalIndex(1, 1), null), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[1, 1]");
    }

    @Test
    public void testMultiDimensionalValues() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(QueryRunnerTestHelper.orderedMap("market", null, "rows", 2L, "index", 200.0, "addRowsIndexConstant", 203.0, "uniques", 0.0, "maxIndex", 100.0, "minIndex", 100.0), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Collections.singletonList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.singletonList(new SearchHit("placement", "mezzanine")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Collections.emptyList())));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(this.schemalessIndexTest.getMergedIncrementalIndex(new int[]{6, 7, 8}), null), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[6, 7]");
    }

    @Test
    public void testDifferentMetrics() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)(NullHandling.sqlCompatible() ? 11L : 10L)).put((Object)"index", (Object)900.0).put((Object)"addRowsIndexConstant", (Object)(NullHandling.sqlCompatible() ? 912.0 : 911.0)).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)(NullHandling.replaceWithDefault() ? 0.0 : 100.0)).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)3L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)204.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(this.schemalessIndexTest.getMergedIncrementalIndexDiffMetrics(), null), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MIIDM");
    }

    private List<Pair<QueryableIndex, String>> getIndexes(int index1, int index2) {
        return Arrays.asList(new Pair((Object)SchemalessIndexTest.getIncrementalIndex(index1, index2), (Object)StringUtils.format((String)"Failed: II[%,d, %,d]", (Object[])new Object[]{index1, index2})), new Pair((Object)SchemalessIndexTest.getIncrementalIndex(index2, index1), (Object)StringUtils.format((String)"Failed: II[%,d, %,d]", (Object[])new Object[]{index2, index1})), new Pair((Object)this.schemalessIndexTest.getMergedIncrementalIndex(index1, index2), (Object)StringUtils.format((String)"Failed: MII[%,d, %,d]", (Object[])new Object[]{index1, index2})), new Pair((Object)this.schemalessIndexTest.getMergedIncrementalIndex(index2, index1), (Object)StringUtils.format((String)"Failed: MII[%,d, %,d]", (Object[])new Object[]{index2, index1})));
    }

    private void testAll(int index1, int index2, List<Result<TimeseriesResultValue>> expectedTimeseriesResults, List<Result<TimeseriesResultValue>> expectedFilteredTimeseriesResults, List<Result<TopNResultValue>> expectedTopNResults, List<Result<TopNResultValue>> expectedFilteredTopNResults, List<Result<SearchResultValue>> expectedSearchResults, List<Result<SearchResultValue>> expectedFilteredSearchResults, List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults) {
        for (Pair<QueryableIndex, String> entry : this.getIndexes(index1, index2)) {
            this.runTests((Segment)new QueryableIndexSegment((QueryableIndex)entry.lhs, null), expectedTimeseriesResults, expectedFilteredTimeseriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, (String)entry.rhs);
        }
    }

    private void runTests(Segment adapter, List<Result<TimeseriesResultValue>> expectedTimeseriesResults, List<Result<TimeseriesResultValue>> expectedFilteredTimeseriesResults, List<Result<TopNResultValue>> expectedTopNResults, List<Result<TopNResultValue>> expectedFilteredTopNResults, List<Result<SearchResultValue>> expectedSearchResults, List<Result<SearchResultValue>> expectedFilteredSearchResults, List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults, String failMsg) {
        this.testFullOnTimeseries(TestQueryRunners.makeTimeSeriesQueryRunner(adapter), expectedTimeseriesResults, failMsg);
        this.testFilteredTimeseries(TestQueryRunners.makeTimeSeriesQueryRunner(adapter), expectedFilteredTimeseriesResults, failMsg);
        this.testFullOnSearch(TestQueryRunners.makeSearchQueryRunner(adapter), expectedSearchResults, failMsg);
        this.testFilteredSearch(TestQueryRunners.makeSearchQueryRunner(adapter), expectedFilteredSearchResults, failMsg);
        this.testTimeBoundary(TestQueryRunners.makeTimeBoundaryQueryRunner(adapter), expectedTimeBoundaryResults, failMsg);
    }

    private void testFullOnTimeseries(QueryRunner runner, List<Result<TimeseriesResultValue>> expectedResults, String failMsg) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        failMsg = failMsg + " timeseries ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredTimeseries(QueryRunner runner, List<Result<TimeseriesResultValue>> expectedResults, String failMsg) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).filters("market", "spot").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        failMsg = failMsg + " filtered timeseries ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFullOnTopN(QueryRunner runner, List<Result<TopNResultValue>> expectedResults, String failMsg) {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        failMsg = failMsg + " topN ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredTopN(QueryRunner runner, List<Result<TopNResultValue>> expectedResults, String failMsg) {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).dimension("market").filters("market", "spot").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        failMsg = failMsg + " filtered topN ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFullOnSearch(QueryRunner runner, List<Result<SearchResultValue>> expectedResults, String failMsg) {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).query("a").build();
        failMsg = failMsg + " search ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredSearch(QueryRunner runner, List<Result<SearchResultValue>> expectedResults, String failMsg) {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).filters("market", "spot").intervals(this.fullOnInterval).query("a").build();
        failMsg = failMsg + " filtered search ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testTimeBoundary(QueryRunner runner, List<Result<TimeBoundaryResultValue>> expectedResults, String failMsg) {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        failMsg = failMsg + " timeBoundary ";
        List actualResults = runner.run(QueryPlus.wrap((Query)query)).toList();
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }
}

