/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.segment.AbstractSegment;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.org.apache.druid.segment.Segment;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.timeline.SegmentId;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReferenceCountingSegmentTest {
    private ReferenceCountingSegment segment;
    private ExecutorService exec;

    @Before
    public void setUp() {
        this.segment = ReferenceCountingSegment.wrapRootGenerationSegment((Segment)new AbstractSegment(){

            public SegmentId getId() {
                return SegmentId.dummy((String)"test_segment");
            }

            public Interval getDataInterval() {
                return new Interval((ReadableInstant)DateTimes.nowUtc().minus((ReadablePeriod)Days.days((int)1)), (ReadableInstant)DateTimes.nowUtc());
            }

            public QueryableIndex asQueryableIndex() {
                return null;
            }

            public StorageAdapter asStorageAdapter() {
                return null;
            }

            public void close() {
            }
        });
        this.exec = Executors.newSingleThreadExecutor();
    }

    @Test
    public void testMultipleClose() throws Exception {
        Assert.assertFalse((boolean)this.segment.isClosed());
        Assert.assertTrue((boolean)this.segment.increment());
        Assert.assertEquals((long)1L, (long)this.segment.getNumReferences());
        Closeable closeable = this.segment.decrementOnceCloseable();
        closeable.close();
        closeable.close();
        this.exec.submit(() -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertFalse((boolean)this.segment.isClosed());
        this.segment.close();
        this.segment.close();
        this.exec.submit(() -> {
            try {
                this.segment.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertTrue((boolean)this.segment.isClosed());
        this.segment.increment();
        this.segment.increment();
        this.segment.increment();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        this.segment.close();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
    }
}

