/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.io.File;
import java.util.Collection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.segment.CloserRule;
import org.apache.hive.druid.org.apache.druid.segment.IndexIO;
import org.apache.hive.druid.org.apache.druid.segment.IndexMerger;
import org.apache.hive.druid.org.apache.druid.segment.IndexMergerTestBase;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapValues;
import org.apache.hive.druid.org.apache.druid.segment.data.CloseableIndexed;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.hive.druid.org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class QueryableIndexIndexableAdapterTest {
    private static final IndexSpec INDEX_SPEC = IndexMergerTestBase.makeIndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final CloserRule closer = new CloserRule(false);
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public QueryableIndexIndexableAdapterTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
        this.indexIO = TestHelper.getTestIndexIO();
    }

    @Test
    public void testGetBitmapIndex() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, INDEX_SPEC, null)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
        String dimension = "dim1";
        BitmapValues bitmapValues = adapter.getBitmapValues(dimension, 0);
        try (CloseableIndexed dimValueLookup = adapter.getDimValueLookup(dimension);){
            for (int i = 0; i < dimValueLookup.size(); ++i) {
                bitmapValues = adapter.getBitmapValues(dimension, i);
                Assert.assertEquals((long)1L, (long)bitmapValues.size());
            }
        }
    }
}

