/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.segment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.Metadata;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        AggregatorFactory[] aggregators = new AggregatorFactory[]{new LongSumAggregatorFactory("out", "in")};
        Metadata metadata = new Metadata(Collections.singletonMap("k", "v"), aggregators, null, Granularities.ALL, Boolean.FALSE);
        Metadata other = (Metadata)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)metadata), Metadata.class);
        Assert.assertEquals((Object)metadata, (Object)other);
    }

    @Test
    public void testMerge() {
        Assert.assertNull((Object)Metadata.merge(null, null));
        Assert.assertNull((Object)Metadata.merge((List)ImmutableList.of(), null));
        ArrayList<Metadata> metadataToBeMerged = new ArrayList<Metadata>();
        metadataToBeMerged.add(null);
        Assert.assertNull((Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] aggs = new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "f")};
        Metadata m1 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE);
        Metadata m2 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE);
        Metadata m3 = new Metadata(Collections.singletonMap("k", "v"), aggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.TRUE);
        Metadata merged = new Metadata(Collections.singletonMap("k", "v"), new AggregatorFactory[]{new LongMaxAggregatorFactory("n", "n")}, new TimestampSpec("ds", "auto", null), Granularities.ALL, Boolean.FALSE);
        Assert.assertEquals((Object)merged, (Object)Metadata.merge((List)ImmutableList.of((Object)m1, (Object)m2), null));
        metadataToBeMerged.clear();
        metadataToBeMerged.add(m1);
        metadataToBeMerged.add(m2);
        metadataToBeMerged.add(null);
        Metadata merged2 = new Metadata(Collections.singletonMap("k", "v"), null, null, null, null);
        Assert.assertEquals((Object)merged2, (Object)Metadata.merge(metadataToBeMerged, null));
        AggregatorFactory[] explicitAggs = new AggregatorFactory[]{new DoubleMaxAggregatorFactory("x", "y")};
        Metadata merged3 = new Metadata(Collections.singletonMap("k", "v"), explicitAggs, null, null, null);
        Assert.assertEquals((Object)merged3, (Object)Metadata.merge(metadataToBeMerged, (AggregatorFactory[])explicitAggs));
        Metadata merged4 = new Metadata(Collections.singletonMap("k", "v"), explicitAggs, new TimestampSpec("ds", "auto", null), Granularities.ALL, null);
        Assert.assertEquals((Object)merged4, (Object)Metadata.merge((List)ImmutableList.of((Object)m3, (Object)m2), (AggregatorFactory[])explicitAggs));
    }
}

